/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuthService;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.creator.OAuthProfileCreator;

public class OAuth10ProfileCreator
extends OAuthProfileCreator {
    public OAuth10ProfileCreator(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    protected OAuth1AccessToken getAccessToken(Credentials credentials) {
        return ((OAuth10Credentials)credentials).getAccessToken();
    }

    @Override
    protected void addAccessTokenToProfile(UserProfile userProfile, Token tok) {
        OAuth10Profile profile = (OAuth10Profile)userProfile;
        OAuth1AccessToken accessToken = (OAuth1AccessToken)tok;
        if (profile != null) {
            String token = accessToken.getToken();
            this.logger.debug("add access_token: {} to profile", (Object)token);
            profile.setAccessToken(token);
            profile.setAccessSecret(accessToken.getTokenSecret());
        }
    }

    @Override
    protected void signRequest(OAuthService service, Token tok, OAuthRequest request) {
        OAuth1AccessToken token = (OAuth1AccessToken)tok;
        ((OAuth10aService)service).signRequest(token, request);
        if (this.configuration.isTokenAsHeader()) {
            request.addHeader("Authorization", "Bearer " + token.getToken());
        }
    }
}

