/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuthService;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.yahoo.YahooProfile;

public class YahooProfileCreator
extends OAuth10ProfileCreator {
    public YahooProfileCreator(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected Optional<UserProfile> retrieveUserProfileFromToken(WebContext context, Token accessToken) {
        OAuthProfileDefinition profileDefinition = this.configuration.getProfileDefinition();
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        OAuth10aService service = (OAuth10aService)this.configuration.buildService(context, this.client);
        String body = this.sendRequestForData((OAuthService)service, accessToken, profileUrl, profileDefinition.getProfileVerb());
        String guid = CommonHelper.substringBetween((String)body, (String)"<value>", (String)"</value>");
        this.logger.debug("guid : {}", (Object)guid);
        if (CommonHelper.isBlank((String)guid)) {
            throw new HttpCommunicationException("Cannot find guid from body : " + body);
        }
        body = this.sendRequestForData((OAuthService)service, accessToken, "https://social.yahooapis.com/v1/user/" + guid + "/profile?format=json", Verb.GET);
        YahooProfile profile = (YahooProfile)this.configuration.getProfileDefinition().extractUserProfile(body);
        this.addAccessTokenToProfile((UserProfile)profile, accessToken);
        return Optional.of(profile);
    }
}

