/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.dropbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.dropbox.DropBoxProfile;

public class DropBoxProfileDefinition
extends OAuthProfileDefinition {
    public static final String REFERRAL_LINK = "referral_link";
    public static final String COUNTRY = "country";
    public static final String EMAIL_VERIFIED = "email_verified";

    public DropBoxProfileDefinition() {
        super(x -> new DropBoxProfile());
        this.primary(REFERRAL_LINK, (AttributeConverter)Converters.STRING);
        this.primary(COUNTRY, (AttributeConverter)Converters.LOCALE);
        this.primary(REFERRAL_LINK, (AttributeConverter)Converters.URL);
        this.primary("email", (AttributeConverter)Converters.STRING);
        this.primary(EMAIL_VERIFIED, (AttributeConverter)Converters.BOOLEAN);
    }

    @Override
    public String getProfileUrl(Token token, OAuthConfiguration configuration) {
        return "https://api.dropboxapi.com/2/users/get_current_account";
    }

    @Override
    public Verb getProfileVerb() {
        return Verb.POST;
    }

    @Override
    public DropBoxProfile extractUserProfile(String body) {
        DropBoxProfile profile = (DropBoxProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, "account_id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
            if ((json = (JsonNode)JsonHelper.getElement(json, "name")) != null) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, "first_name", JsonHelper.getElement(json, "familiar_name"));
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, "family_name", JsonHelper.getElement(json, "surname"));
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, "display_name", JsonHelper.getElement(json, "display_name"));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

