/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.casoauthwrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.scribejava.core.model.Token;
import java.util.Iterator;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.casoauthwrapper.CasAuthenticationDateFormatter;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfile;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.scribe.builder.api.CasOAuthWrapperApi20;

public class CasOAuthWrapperProfileDefinition
extends OAuthProfileDefinition {
    private static final String ID = "id";
    public static final String IS_FROM_NEW_LOGIN = "isFromNewLogin";
    public static final String AUTHENTICATION_DATE = "authenticationDate";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String SUCCESSFUL_AUTHENTICATION_HANDLERS = "successfulAuthenticationHandlers";
    public static final String LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED = "longTermAuthenticationRequestTokenUsed";

    public CasOAuthWrapperProfileDefinition() {
        super(x -> new CasOAuthWrapperProfile());
        this.primary(IS_FROM_NEW_LOGIN, (AttributeConverter)Converters.BOOLEAN);
        this.primary(AUTHENTICATION_DATE, (AttributeConverter)new CasAuthenticationDateFormatter());
        this.primary(AUTHENTICATION_METHOD, (AttributeConverter)Converters.STRING);
        this.primary(SUCCESSFUL_AUTHENTICATION_HANDLERS, (AttributeConverter)Converters.STRING);
        this.primary(LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED, (AttributeConverter)Converters.BOOLEAN);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return ((CasOAuthWrapperApi20)((Object)((OAuth20Configuration)configuration).getApi())).getCasServerUrl() + "/profile";
    }

    @Override
    public CasOAuthWrapperProfile extractUserProfile(String body) {
        CasOAuthWrapperProfile profile = (CasOAuthWrapperProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, ID)));
            JsonNode attributes = json.get("attributes");
            if (attributes != null) {
                this.extractAttributes(attributes, profile);
            } else {
                this.extractAttributes(json, profile);
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }

    protected void extractAttributes(JsonNode json, CasOAuthWrapperProfile profile) {
        block3: {
            block2: {
                if (!(json instanceof ArrayNode)) break block2;
                for (JsonNode nextNode : json) {
                    String attribute = (String)nextNode.fieldNames().next();
                    if (ID.equals(attribute)) continue;
                    this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(nextNode, attribute));
                }
                break block3;
            }
            if (!(json instanceof ObjectNode)) break block3;
            Iterator keys = json.fieldNames();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (ID.equals(key)) continue;
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, JsonHelper.getElement(json, key));
            }
        }
    }
}

