/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.casoauthwrapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.scribejava.core.model.Token;
import java.util.Iterator;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.casoauthwrapper.CasAuthenticationDateFormatter;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfile;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.scribe.builder.api.CasOAuthWrapperApi20;

public class CasOAuthWrapperProfileDefinition
extends OAuthProfileDefinition {
    public static final String IS_FROM_NEW_LOGIN = "isFromNewLogin";
    public static final String AUTHENTICATION_DATE = "authenticationDate";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String SUCCESSFUL_AUTHENTICATION_HANDLERS = "successfulAuthenticationHandlers";
    public static final String LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED = "longTermAuthenticationRequestTokenUsed";

    public CasOAuthWrapperProfileDefinition() {
        super(x -> new CasOAuthWrapperProfile());
        this.primary(IS_FROM_NEW_LOGIN, Converters.BOOLEAN);
        this.primary(AUTHENTICATION_DATE, (AttributeConverter)new CasAuthenticationDateFormatter());
        this.primary(AUTHENTICATION_METHOD, Converters.STRING);
        this.primary(SUCCESSFUL_AUTHENTICATION_HANDLERS, Converters.STRING);
        this.primary(LONG_TERM_AUTHENTICATION_REQUEST_TOKEN_USED, Converters.BOOLEAN);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return ((CasOAuthWrapperApi20)((Object)configuration.getApi())).getCasServerUrl() + "/profile";
    }

    @Override
    public CasOAuthWrapperProfile extractUserProfile(String body) {
        CasOAuthWrapperProfile profile = (CasOAuthWrapperProfile)this.newProfile(new Object[0]);
        String attributesNode = "attributes";
        JsonNode json2 = JsonHelper.getFirstNode(body);
        if (json2 != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json2, "id")));
            json2 = json2.get("attributes");
            if (json2 != null) {
                if (json2 instanceof ArrayNode) {
                    for (JsonNode json2 : json2) {
                        String attribute = (String)json2.fieldNames().next();
                        this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json2, attribute));
                    }
                } else if (json2 instanceof ObjectNode) {
                    Iterator keys = json2.fieldNames();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, JsonHelper.getElement(json2, key));
                    }
                }
            } else {
                this.raiseProfileExtractionJsonError(body, "attributes");
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

