/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.authenticator.OAuth10Authenticator;
import org.pac4j.oauth.credentials.extractor.OAuth10CredentialsExtractor;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.redirect.OAuth10RedirectionActionBuilder;

public class OAuth10Client
extends IndirectClient {
    protected OAuth10Configuration configuration = new OAuth10Configuration();

    protected void beforeInternalInit(boolean forceReinit) {
        super.beforeInternalInit(forceReinit);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    protected void internalInit(boolean forceReinit) {
        this.setRedirectionActionBuilderIfUndefined(new OAuth10RedirectionActionBuilder(this.configuration, this));
        this.setCredentialsExtractorIfUndefined(new OAuth10CredentialsExtractor(this.configuration, (IndirectClient)this));
        this.setAuthenticatorIfUndefined(new OAuth10Authenticator(this.configuration, (IndirectClient)this));
        this.setProfileCreatorIfUndefined(new OAuth10ProfileCreator(this.configuration, (IndirectClient)this));
    }

    public String getKey() {
        return this.configuration.getKey();
    }

    public void setKey(String key) {
        this.configuration.setKey(key);
    }

    public String getSecret() {
        return this.configuration.getSecret();
    }

    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OAuth10Client(super=" + super.toString() + ", configuration=" + String.valueOf((Object)this.configuration) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OAuth10Configuration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(OAuth10Configuration configuration) {
        this.configuration = configuration;
    }
}

