/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.authenticator.OAuth20Authenticator;
import org.pac4j.oauth.credentials.extractor.OAuth20CredentialsExtractor;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.redirect.OAuth20RedirectionActionBuilder;

public class OAuth20Client
extends IndirectClient {
    protected OAuth20Configuration configuration = new OAuth20Configuration();

    protected void beforeInternalInit(boolean forceReinit) {
        super.beforeInternalInit(forceReinit);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    protected void internalInit(boolean forceReinit) {
        this.setRedirectionActionBuilderIfUndefined(new OAuth20RedirectionActionBuilder(this.configuration, this));
        this.setCredentialsExtractorIfUndefined(new OAuth20CredentialsExtractor(this.configuration, (IndirectClient)this));
        this.setAuthenticatorIfUndefined(new OAuth20Authenticator(this.configuration, (IndirectClient)this));
        this.setProfileCreatorIfUndefined(new OAuth20ProfileCreator(this.configuration, (IndirectClient)this));
    }

    public String getKey() {
        return this.configuration.getKey();
    }

    public void setKey(String key) {
        this.configuration.setKey(key);
    }

    public String getSecret() {
        return this.configuration.getSecret();
    }

    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OAuth20Client(super=" + super.toString() + ", configuration=" + String.valueOf((Object)this.configuration) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OAuth20Configuration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(OAuth20Configuration configuration) {
        this.configuration = configuration;
    }
}

