/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.strava;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.pac4j.core.profile.Gender;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.strava.StravaClub;
import org.pac4j.oauth.profile.strava.StravaGear;

public class StravaProfile
extends OAuth20Profile {
    private static final long serialVersionUID = 995023712830997358L;
    private static final String STRAVA_PROFILE_BASE_URL = "http://www.strava.com/athletes/";

    public String getFirstName() {
        return (String)this.getAttribute("firstname");
    }

    public String getFamilyName() {
        return (String)this.getAttribute("lastname");
    }

    public String getDisplayName() {
        return String.valueOf(this.getAttribute("firstname")) + " " + String.valueOf(this.getAttribute("lastname"));
    }

    public URI getPictureUrl() {
        return (URI)this.getAttribute("profile");
    }

    public URI getProfileUrl() {
        return CommonHelper.asURI((String)(STRAVA_PROFILE_BASE_URL + String.valueOf(this.getAttribute("id"))));
    }

    public String getLocation() {
        return (String)this.getAttribute("city");
    }

    public Gender getGender() {
        return (Gender)this.getAttribute("sex");
    }

    public Integer getResourceState() {
        return (Integer)this.getAttribute("resource_state");
    }

    public String getProfileMedium() {
        return (String)this.getAttribute("profile_medium");
    }

    public String getState() {
        return (String)this.getAttribute("state");
    }

    public String getCountry() {
        return (String)this.getAttribute("country");
    }

    public Boolean isPremium() {
        return (Boolean)this.getAttribute("premium");
    }

    public Date getCreatedAt() {
        return (Date)this.getAttribute("created_at");
    }

    public Date getUpdatedAt() {
        return (Date)this.getAttribute("updated_at");
    }

    public Integer getFollowerCount() {
        return (Integer)this.getAttribute("follower_count");
    }

    public Integer getFriendCount() {
        return (Integer)this.getAttribute("friend_count");
    }

    public String getDatePreference() {
        return (String)this.getAttribute("date_preference");
    }

    public String getMeasurementPreference() {
        return (String)this.getAttribute("measurement_preference");
    }

    public List<StravaGear> getBikes() {
        return (List)this.getAttribute("bikes");
    }

    public List<StravaGear> getShoes() {
        return (List)this.getAttribute("shoes");
    }

    public List<StravaClub> getClubs() {
        return (List)this.getAttribute("clubs");
    }
}

