/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.DefaultResourceRetriever;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ResourceRetriever;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;

public class OidcClient
extends IndirectClient<OidcCredentials, OidcProfile> {
    private static final String STATE_ATTRIBUTE = "oidcStateAttribute";
    private static final String NONCE_ATTRIBUTE = "oidcNonceAttribute";
    private static final int DEFAULT_MAX_CLOCK_SKEW = 30;
    private String clientId;
    private String secret;
    private URI redirectURI;
    private String discoveryURI;
    private IDTokenValidator idTokenValidator;
    private OIDCProviderMetadata oidcProvider;
    private Map<String, String> authParams;
    private String scope;
    private Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthentication clientAuthentication;
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private ClientID _clientID;
    private Secret _secret;
    private boolean useNonce;
    private JWSAlgorithm preferredJwsAlgorithm;
    private int maxClockSkew = 30;
    private int connectTimeout = 500;
    private int readTimeout = 5000;

    public OidcClient() {
    }

    public OidcClient(String clientId, String secret, String discoveryURI) {
        this.clientId = clientId;
        this.secret = secret;
        this.discoveryURI = discoveryURI;
    }

    public ClientType getClientType() {
        return ClientType.OPENID_CONNECT_PROTOCOL;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setClientID(String clientID) {
        this.clientId = clientID;
    }

    public String getClientID() {
        return this.clientId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public IDTokenValidator getIdTokenValidator() {
        return this.idTokenValidator;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    public void setCustomParams(Map<String, String> customParams) {
        CommonHelper.assertNotNull((String)"customParams", customParams);
        this.customParams = customParams;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Map<String, String> getAuthParams() {
        return this.authParams;
    }

    public OIDCProviderMetadata getProviderMetadata() {
        return this.oidcProvider;
    }

    public URI getRedirectURI() {
        return this.redirectURI;
    }

    public ClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    protected void internalInit(WebContext context) {
        ClientAuthenticationMethod method;
        CommonHelper.assertNotBlank((String)this.getClientID(), (String)"clientID cannot be blank");
        CommonHelper.assertNotBlank((String)this.getSecret(), (String)"secret cannot be blank");
        CommonHelper.assertNotBlank((String)this.getDiscoveryURI(), (String)"discoveryURI cannot be blank");
        this.authParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.getScope())) {
            this.authParams.put("scope", this.getScope());
        } else {
            this.authParams.put("scope", "openid profile email");
        }
        this.authParams.put("response_type", "code");
        String computedCallbackUrl = this.computeFinalCallbackUrl(context);
        this.authParams.put("redirect_uri", computedCallbackUrl);
        this.authParams.putAll(this.getCustomParams());
        this.authParams.put("client_id", this.getClientID());
        this.authParams.put("client_secret", this.getSecret());
        this._clientID = new ClientID(this.getClientID());
        this._secret = new Secret(this.getSecret());
        try {
            JWSAlgorithm jwsAlgorithm;
            ResourceRetriever resourceRetriever = this.createResourceRetriever();
            this.oidcProvider = OIDCProviderMetadata.parse((String)resourceRetriever.retrieveResource(new URL(this.getDiscoveryURI())).getContent());
            this.redirectURI = new URI(computedCallbackUrl);
            List algorithms = this.getProviderMetadata().getIDTokenJWSAlgs();
            CommonHelper.assertTrue((algorithms != null && algorithms.size() > 0 ? 1 : 0) != 0, (String)"There must at least one JWS algorithm supported on the OpenID Connect provider side");
            if (algorithms.contains(this.getPreferredJwsAlgorithm())) {
                jwsAlgorithm = this.getPreferredJwsAlgorithm();
            } else {
                jwsAlgorithm = (JWSAlgorithm)algorithms.get(0);
                this.logger.warn("Preferred JWS algorithm: {} not available. Defaulting to: {}", (Object)this.getPreferredJwsAlgorithm(), (Object)jwsAlgorithm);
            }
            this.idTokenValidator = CommonHelper.isNotBlank((String)this.getSecret()) && (jwsAlgorithm == JWSAlgorithm.HS256 || jwsAlgorithm == JWSAlgorithm.HS384 || jwsAlgorithm == JWSAlgorithm.HS512) ? this.createHMACTokenValidator(jwsAlgorithm, this._clientID, this._secret) : this.createRSATokenValidator(jwsAlgorithm, this._clientID);
            this.getIdTokenValidator().setMaxClockSkew(this.getMaxClockSkew());
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new TechnicalException(e);
        }
        List methods = this.getProviderMetadata().getTokenEndpointAuthMethods();
        if (!methods.isEmpty()) {
            if (methods.contains(this.getClientAuthenticationMethod())) {
                method = this.getClientAuthenticationMethod();
            } else {
                method = (ClientAuthenticationMethod)this.getProviderMetadata().getTokenEndpointAuthMethods().get(0);
                this.logger.warn("Preferred token endpoint Authentication method: {} not available. Defaulting to: {}", (Object)this.getClientAuthenticationMethod(), (Object)method);
            }
        } else {
            method = ClientAuthenticationMethod.getDefault();
            this.logger.warn("Provider metadata does not provide Token endpoint authentication methods. Defaulting to: {}", (Object)method);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)method)) {
            this.clientAuthentication = new ClientSecretPost(this._clientID, this._secret);
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)method)) {
            this.clientAuthentication = new ClientSecretBasic(this._clientID, this._secret);
        }
    }

    protected IDTokenValidator createRSATokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID) throws MalformedURLException {
        return new IDTokenValidator(this.getProviderMetadata().getIssuer(), clientID, jwsAlgorithm, this.getProviderMetadata().getJWKSetURI().toURL());
    }

    protected IDTokenValidator createHMACTokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID, Secret secret) {
        return new IDTokenValidator(this.getProviderMetadata().getIssuer(), clientID, jwsAlgorithm, secret);
    }

    protected ResourceRetriever createResourceRetriever() {
        return new DefaultResourceRetriever(this.getConnectTimeout(), this.getReadTimeout());
    }

    protected IndirectClient<OidcCredentials, OidcProfile> newClient() {
        OidcClient client = new OidcClient();
        client.setClientID(this.getClientID());
        client.setSecret(this.getSecret());
        client.setDiscoveryURI(this.getDiscoveryURI());
        client.setAuthParams(this.getAuthParams());
        client.setUseNonce(this.isUseNonce());
        client.setPreferredJwsAlgorithm(this.getPreferredJwsAlgorithm());
        client.setMaxClockSkew(this.getMaxClockSkew());
        client.setConnectTimeout(this.getConnectTimeout());
        client.setReadTimeout(this.getReadTimeout());
        return client;
    }

    protected boolean isDirectRedirection() {
        return false;
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        String queryString;
        HashMap<String, String> params = new HashMap<String, String>(this.getAuthParams());
        State state = new State();
        params.put("state", state.getValue());
        context.setSessionAttribute(STATE_ATTRIBUTE, (Object)state);
        if (this.isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            context.setSessionAttribute(NONCE_ATTRIBUTE, (Object)nonce.getValue());
        }
        try {
            queryString = AuthenticationRequest.parse(params).toQueryString();
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        String location = this.getProviderMetadata().getAuthorizationEndpointURI().toString() + "?" + queryString;
        this.logger.debug("Authentication request url : {}", (Object)location);
        return RedirectAction.redirect((String)location);
    }

    protected OidcCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        AuthenticationResponse response;
        Map<String, String> parameters = this.toSingleParameter(context.getRequestParameters());
        try {
            response = AuthenticationResponseParser.parse((URI)this.getRedirectURI(), parameters);
        }
        catch (ParseException e) {
            throw new TechnicalException((Throwable)e);
        }
        if (response instanceof AuthenticationErrorResponse) {
            this.logger.error("Bad authentication response, error={}", (Object)((AuthenticationErrorResponse)response).getErrorObject());
            return null;
        }
        this.logger.debug("Authentication response successful, get authorization code");
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
        if (!successResponse.getState().equals(context.getSessionAttribute(STATE_ATTRIBUTE))) {
            throw new TechnicalException("State parameter is different from the one sent in authentication request. Session expired or possible threat of cross-site request forgery");
        }
        AuthorizationCode code = successResponse.getAuthorizationCode();
        return new OidcCredentials(code, this.getName());
    }

    protected OidcProfile retrieveUserProfile(OidcCredentials credentials, WebContext context) {
        TokenRequest request = this.buildTokenRequest(credentials);
        try {
            HTTPRequest tokenHttpRequest = request.toHTTPRequest();
            tokenHttpRequest.setConnectTimeout(this.getConnectTimeout());
            tokenHttpRequest.setReadTimeout(this.getReadTimeout());
            HTTPResponse httpResponse = tokenHttpRequest.send();
            this.logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
            TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
            if (response instanceof TokenErrorResponse) {
                String msg = "Bad token response, error=" + ((TokenErrorResponse)response).getErrorObject();
                this.logger.error(msg);
                throw new TechnicalException(msg);
            }
            this.logger.debug("Token response successful");
            OIDCTokenResponse tokenSuccessResponse = (OIDCTokenResponse)response;
            OIDCTokens oidcTokens = tokenSuccessResponse.getOIDCTokens();
            BearerAccessToken accessToken = (BearerAccessToken)oidcTokens.getAccessToken();
            OidcProfile profile = new OidcProfile(accessToken);
            profile.setIdTokenString(oidcTokens.getIDTokenString());
            UserInfo userInfo = null;
            if (this.getProviderMetadata().getUserInfoEndpointURI() != null) {
                UserInfoRequest userInfoRequest = this.buildUserInfoRequest(accessToken);
                HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
                userInfoHttpRequest.setConnectTimeout(this.getConnectTimeout());
                userInfoHttpRequest.setReadTimeout(this.getReadTimeout());
                httpResponse = userInfoHttpRequest.send();
                this.logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    this.logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    userInfo = userInfoSuccessResponse.getUserInfo();
                    if (userInfo != null) {
                        profile.addAttributes(userInfo.toJWTClaimsSet().getClaims());
                    }
                }
            }
            Nonce nonce = this.isUseNonce() ? new Nonce((String)context.getSessionAttribute(NONCE_ATTRIBUTE)) : null;
            IDTokenClaimsSet claimsSet = this.getIdTokenValidator().validate(oidcTokens.getIDToken(), nonce);
            CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
            profile.setId(claimsSet.getSubject());
            return profile;
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected TokenRequest buildTokenRequest(OidcCredentials credentials) {
        return new TokenRequest(this.getProviderMetadata().getTokenEndpointURI(), this.getClientAuthentication(), (AuthorizationGrant)new AuthorizationCodeGrant(credentials.getCode(), this.getRedirectURI()));
    }

    protected UserInfoRequest buildUserInfoRequest(BearerAccessToken accessToken) {
        return new UserInfoRequest(this.getProviderMetadata().getUserInfoEndpointURI(), accessToken);
    }

    private Map<String, String> toSingleParameter(Map<String, String[]> requestParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : requestParameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue()[0]);
        }
        return map;
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public JWSAlgorithm getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    public void setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }
}

