/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import org.pac4j.core.profile.CommonProfile;

public class OidcProfile
extends CommonProfile
implements Externalizable {
    private static final long serialVersionUID = -52855988661742374L;
    private BearerAccessToken accessToken;
    private String idTokenString;
    private JWT idToken;

    public OidcProfile() {
    }

    public OidcProfile(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public BearerAccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public void setIdTokenString(String idTokenString) {
        this.idTokenString = idTokenString;
    }

    public JWT getIdToken() throws ParseException {
        if (this.idToken == null && this.idTokenString != null) {
            this.idToken = JWTParser.parse((String)this.idTokenString);
        }
        return this.idToken;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        BearerAccessTokenBean bean = null;
        if (this.accessToken != null) {
            bean = BearerAccessTokenBean.toBean(this.accessToken);
        }
        out.writeObject(bean);
        out.writeObject(this.idTokenString);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        BearerAccessTokenBean bean = (BearerAccessTokenBean)in.readObject();
        if (bean != null) {
            this.accessToken = BearerAccessTokenBean.fromBean(bean);
        }
        this.idTokenString = (String)in.readObject();
    }

    public void clear() {
        this.accessToken = null;
    }

    private static class BearerAccessTokenBean
    implements Serializable {
        private static final long serialVersionUID = 7726472295622796149L;
        private String value;
        private long lifetime;
        private List<String> scope;

        public BearerAccessTokenBean(String value, long lifetime, List<String> scope) {
            this.value = value;
            this.lifetime = lifetime;
            this.scope = scope;
        }

        public static BearerAccessTokenBean toBean(BearerAccessToken token) {
            Scope scope = token.getScope();
            if (scope != null) {
                return new BearerAccessTokenBean(token.getValue(), token.getLifetime(), scope.toStringList());
            }
            return new BearerAccessTokenBean(token.getValue(), token.getLifetime(), null);
        }

        public static BearerAccessToken fromBean(BearerAccessTokenBean token) {
            return new BearerAccessToken(token.value, token.lifetime, Scope.parse(token.scope));
        }
    }
}

