/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.io.IOException;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.pac4j.oidc.profile.creator.TokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator<U extends OidcProfile>
extends ProfileDefinitionAware<U>
implements ProfileCreator<OidcCredentials, U> {
    private static final Logger logger = LoggerFactory.getLogger(OidcProfileCreator.class);
    protected OidcConfiguration configuration;
    protected TokenValidator tokenValidator;

    public OidcProfileCreator(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        if (this.tokenValidator == null) {
            this.tokenValidator = new TokenValidator(this.configuration);
        }
        this.defaultProfileDefinition((ProfileDefinition)new OidcProfileDefinition());
    }

    public U create(OidcCredentials credentials, WebContext context) {
        this.init();
        AccessToken accessToken = credentials.getAccessToken();
        OidcProfile profile = (OidcProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setAccessToken(accessToken);
        JWT idToken = credentials.getIdToken();
        profile.setIdTokenString(idToken.getParsedString());
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null && !refreshToken.getValue().isEmpty()) {
            profile.setRefreshToken(refreshToken);
            logger.debug("Refresh Token successful retrieved");
        }
        try {
            Nonce nonce = this.configuration.isUseNonce() ? new Nonce((String)context.getSessionStore().get(context, "oidcNonceAttribute")) : null;
            IDTokenClaimsSet claimsSet = this.tokenValidator.validate(idToken, nonce);
            CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)claimsSet.getSubject()));
            if (this.configuration.findProviderMetadata().getUserInfoEndpointURI() != null && accessToken != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.findProviderMetadata().getUserInfoEndpointURI(), (BearerAccessToken)accessToken);
                HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
                userInfoHttpRequest.setConnectTimeout(this.configuration.getConnectTimeout());
                userInfoHttpRequest.setReadTimeout(this.configuration.getReadTimeout());
                HTTPResponse httpResponse = userInfoHttpRequest.send();
                logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
                    this.getProfileDefinition().convertAndAdd((CommonProfile)profile, userInfoClaimsSet.getClaims(), null);
                }
            }
            for (Map.Entry entry : idToken.getJWTClaimsSet().getClaims().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
            }
            profile.setTokenExpirationAdvance(this.configuration.getTokenExpirationAdvance());
            return (U)((Object)profile);
        }
        catch (JOSEException | BadJOSEException | ParseException | IOException | java.text.ParseException e) {
            throw new TechnicalException(e);
        }
    }
}

