/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<IDTokenValidator> idTokenValidators;

    public TokenValidator(OidcConfiguration configuration) {
        List metadataAlgorithms = configuration.findProviderMetadata().getIDTokenJWSAlgs();
        CommonHelper.assertTrue((boolean)CommonHelper.isNotEmpty((Collection)metadataAlgorithms), (String)"There must at least one JWS algorithm supported on the OpenID Connect provider side");
        List jwsAlgorithms = new ArrayList<JWSAlgorithm>();
        JWSAlgorithm preferredAlgorithm = configuration.getPreferredJwsAlgorithm();
        if (metadataAlgorithms.contains(preferredAlgorithm)) {
            jwsAlgorithms.add(preferredAlgorithm);
        } else {
            jwsAlgorithms = metadataAlgorithms;
            this.logger.warn("Preferred JWS algorithm: {} not available. Using all metadata algorithms: {}", (Object)preferredAlgorithm, (Object)metadataAlgorithms);
        }
        this.idTokenValidators = new ArrayList<IDTokenValidator>();
        ClientID _clientID = new ClientID(configuration.getClientId());
        for (JWSAlgorithm jwsAlgorithm : jwsAlgorithms) {
            IDTokenValidator idTokenValidator;
            if ("none".equals(jwsAlgorithm.getName())) {
                jwsAlgorithm = null;
            }
            if (jwsAlgorithm == null) {
                idTokenValidator = new IDTokenValidator(configuration.findProviderMetadata().getIssuer(), _clientID);
            } else if (CommonHelper.isNotBlank((String)configuration.getSecret()) && (JWSAlgorithm.HS256.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS384.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS512.equals((Object)jwsAlgorithm))) {
                Secret _secret = new Secret(configuration.getSecret());
                idTokenValidator = this.createHMACTokenValidator(configuration, jwsAlgorithm, _clientID, _secret);
            } else {
                idTokenValidator = this.createRSATokenValidator(configuration, jwsAlgorithm, _clientID);
            }
            idTokenValidator.setMaxClockSkew(configuration.getMaxClockSkew());
            this.idTokenValidators.add(idTokenValidator);
        }
    }

    protected IDTokenValidator createRSATokenValidator(OidcConfiguration configuration, JWSAlgorithm jwsAlgorithm, ClientID clientID) {
        try {
            return new IDTokenValidator(configuration.findProviderMetadata().getIssuer(), clientID, jwsAlgorithm, configuration.findProviderMetadata().getJWKSetURI().toURL(), configuration.findResourceRetriever());
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected IDTokenValidator createHMACTokenValidator(OidcConfiguration configuration, JWSAlgorithm jwsAlgorithm, ClientID clientID, Secret secret) {
        return new IDTokenValidator(configuration.findProviderMetadata().getIssuer(), clientID, jwsAlgorithm, secret);
    }

    public IDTokenClaimsSet validate(JWT idToken, Nonce expectedNonce) throws BadJOSEException, JOSEException {
        BadJOSEException badJOSEException = null;
        JOSEException joseException = null;
        for (IDTokenValidator idTokenValidator : this.idTokenValidators) {
            try {
                return idTokenValidator.validate(idToken, expectedNonce);
            }
            catch (BadJOSEException e1) {
                this.logger.debug("Validation fails with: {}", (Throwable)e1);
                badJOSEException = e1;
            }
            catch (JOSEException e2) {
                this.logger.debug("Validation fails with: {}", (Throwable)e2);
                joseException = e2;
            }
        }
        if (badJOSEException != null) {
            throw badJOSEException;
        }
        if (joseException != null) {
            throw joseException;
        }
        throw new TechnicalException("Unable to validate the ID token");
    }
}

