/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.PathParameterCallbackUrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpUtils;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.client.azuread.AzureAdResourceRetriever;
import org.pac4j.oidc.config.AzureAdOidcConfiguration;
import org.pac4j.oidc.profile.azuread.AzureAdProfile;
import org.pac4j.oidc.profile.azuread.AzureAdProfileCreator;

@Deprecated
public class AzureAdClient
extends OidcClient {
    protected ObjectMapper objectMapper;
    protected static final TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};

    public AzureAdClient() {
    }

    public AzureAdClient(AzureAdOidcConfiguration configuration) {
        super(configuration);
        this.objectMapper = new ObjectMapper();
    }

    @Override
    protected void internalInit() {
        this.getConfiguration().setResourceRetriever(new AzureAdResourceRetriever());
        this.defaultProfileCreator(new AzureAdProfileCreator(this.getConfiguration(), this));
        super.internalInit();
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new PathParameterCallbackUrlResolver();
    }

    public String getAccessTokenFromRefreshToken(AzureAdProfile azureAdProfile) {
        String string;
        AzureAdOidcConfiguration azureConfig = (AzureAdOidcConfiguration)this.getConfiguration();
        CommonHelper.assertTrue((boolean)CommonHelper.isNotBlank((String)azureConfig.getTenant()), (String)"Tenant must be defined. Update your config.");
        HttpURLConnection connection = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put("Accept", "application/json");
            connection = HttpUtils.openPostConnection((URL)new URL("https://login.microsoftonline.com/" + azureConfig.getTenant() + "/oauth2/token"), headers);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
            out.write(azureConfig.makeOauth2TokenRequest(azureAdProfile.getRefreshToken().getValue()));
            out.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TechnicalException("request for access token failed: " + HttpUtils.buildHttpErrorMessage((HttpURLConnection)connection));
            }
            String body = HttpUtils.readBody((HttpURLConnection)connection);
            Map res = (Map)this.objectMapper.readValue(body, typeRef);
            string = (String)res.get("access_token");
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection((HttpURLConnection)connection);
        return string;
    }
}

