/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.oauth2.sdk.token.RefreshToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.credentials.extractor.OidcCredentialsExtractor;
import org.pac4j.oidc.logout.OidcLogoutActionBuilder;
import org.pac4j.oidc.logout.processor.OidcLogoutProcessor;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.creator.OidcProfileCreator;
import org.pac4j.oidc.redirect.OidcRedirectionActionBuilder;

public class OidcClient
extends IndirectClient {
    private OidcConfiguration configuration;

    public OidcClient() {
    }

    public OidcClient(OidcConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    protected void beforeInternalInit(boolean forceReinit) {
        super.beforeInternalInit(forceReinit);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    protected void internalInit(boolean forceReinit) {
        this.configuration.init(forceReinit);
        this.setRedirectionActionBuilderIfUndefined(new OidcRedirectionActionBuilder(this));
        this.setCredentialsExtractorIfUndefined(new OidcCredentialsExtractor(this.configuration, this));
        this.setAuthenticatorIfUndefined(new OidcAuthenticator(this.configuration, this));
        this.setProfileCreatorIfUndefined(new OidcProfileCreator(this.configuration, this));
        this.setLogoutProcessorIfUndefined(new OidcLogoutProcessor(this.configuration, this.findSessionLogoutHandler()));
        this.setLogoutActionBuilderIfUndefined(new OidcLogoutActionBuilder(this.configuration));
    }

    public Optional<UserProfile> renewUserProfile(CallContext ctx, UserProfile profile) {
        OidcProfile oidcProfile = (OidcProfile)profile;
        RefreshToken refreshToken = oidcProfile.getRefreshToken();
        if (refreshToken != null) {
            OidcCredentials credentials = new OidcCredentials();
            credentials.setRefreshTokenObject(refreshToken);
            OidcAuthenticator authenticator = new OidcAuthenticator(this.getConfiguration(), this);
            authenticator.refresh(credentials);
            if (credentials.getAccessToken() != null) {
                return this.getUserProfile(ctx, credentials);
            }
        }
        return Optional.empty();
    }

    public void notifySessionRenewal(CallContext ctx, String oldSessionId) {
        SessionLogoutHandler sessionLogoutHandler = this.findSessionLogoutHandler();
        if (sessionLogoutHandler != null) {
            sessionLogoutHandler.renewSession(ctx, oldSessionId);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OidcClient(super=" + super.toString() + ", configuration=" + String.valueOf((Object)this.configuration) + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }
}

