/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.extractor;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.BadRequestAction;
import org.pac4j.core.logout.LogoutType;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.exceptions.OidcIssuerMismatchException;
import org.pac4j.oidc.exceptions.OidcMissingSessionStateException;
import org.pac4j.oidc.exceptions.OidcMissingStateParameterException;
import org.pac4j.oidc.exceptions.OidcStateMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcCredentialsExtractor
implements CredentialsExtractor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCredentialsExtractor.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcCredentialsExtractor(OidcConfiguration configuration, OidcClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<Credentials> extract(CallContext ctx) {
        AccessToken accessToken;
        JWT idToken;
        AuthenticationResponse response;
        WebContext webContext = ctx.webContext();
        Optional logoutToken = webContext.getRequestParameter("logout_token");
        Optional sid = webContext.getRequestParameter("sid");
        if (logoutToken.isPresent()) {
            try {
                String sessionId;
                JWT jwt = JWTParser.parse((String)((String)logoutToken.get()));
                if (jwt instanceof EncryptedJWT) {
                    LOGGER.error("Encrypted JWTs are not accepted for logout requests");
                    throw new BadRequestAction();
                }
                if (this.configuration.isLogoutValidation()) {
                    Map mapEvents;
                    IDTokenClaimsSet claims = this.configuration.getOpMetadataResolver().getTokenValidator().validate(jwt, null);
                    if (claims.getClaim("nonce") != null) {
                        LOGGER.error("The nonce claim should not exist for logout requests");
                        throw new BadRequestAction();
                    }
                    Object events = claims.getClaim("events");
                    if (!(events instanceof Map) || !(mapEvents = (Map)events).containsKey("http://schemas.openid.net/event/backchannel-logout")) {
                        LOGGER.error("The events claim should contain the 'http://schemas.openid.net/event/backchannel-logout' member name for logout requests");
                        throw new BadRequestAction();
                    }
                    sessionId = (String)claims.getClaim("sid");
                    if (CommonHelper.isBlank((String)sessionId)) {
                        LOGGER.error("The sid claim is mandatory for logout requests");
                        throw new BadRequestAction();
                    }
                } else {
                    sessionId = (String)jwt.getJWTClaimsSet().getClaim("sid");
                }
                LOGGER.debug("Handling back-channel logout for sessionId: {}", (Object)sessionId);
                return Optional.of(new SessionKeyCredentials(LogoutType.BACK, sessionId));
            }
            catch (JOSEException | BadJOSEException | java.text.ParseException e) {
                LOGGER.error("Cannot validate JWT logout token", e);
                throw new BadRequestAction();
            }
        }
        if (sid.isPresent()) {
            String sessionId = (String)sid.get();
            LOGGER.debug("Handling front-channel logout for sessionId: {}", (Object)sessionId);
            return Optional.of(new SessionKeyCredentials(LogoutType.FRONT, sessionId));
        }
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(webContext);
        Map<String, List<String>> parameters = this.retrieveParameters(webContext);
        try {
            response = AuthenticationResponseParser.parse((URI)new URI(computedCallbackUrl), parameters);
        }
        catch (ParseException | URISyntaxException e) {
            throw new OidcException(e);
        }
        if (response instanceof AuthenticationErrorResponse) {
            LOGGER.error("Bad authentication response, error={}", (Object)((AuthenticationErrorResponse)response).getErrorObject());
            return Optional.empty();
        }
        LOGGER.debug("Authentication response successful");
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)this.configuration.getOpMetadataResolver().load();
        if (metadata.supportsAuthorizationResponseIssuerParam() && !metadata.getIssuer().equals((Object)successResponse.getIssuer())) {
            throw new OidcIssuerMismatchException("Issuer mismatch, possible mix-up attack.");
        }
        if (this.configuration.isWithState()) {
            State requestState = (State)this.configuration.getValueRetriever().retrieve(ctx, this.client.getStateSessionAttributeName(), this.client).orElseThrow(() -> new OidcMissingSessionStateException("State cannot be determined"));
            State responseState = successResponse.getState();
            if (responseState == null) {
                throw new OidcMissingStateParameterException("Missing state parameter");
            }
            LOGGER.debug("Request state: {}/response state: {}", (Object)requestState, (Object)responseState);
            if (!requestState.equals((Object)responseState)) {
                throw new OidcStateMismatchException("State parameter is different from the one sent in authentication request.");
            }
        }
        OidcCredentials credentials = new OidcCredentials();
        AuthorizationCode code = successResponse.getAuthorizationCode();
        if (code != null) {
            credentials.setCode(code.getValue());
        }
        if ((idToken = successResponse.getIDToken()) != null) {
            credentials.setIdToken(idToken.serialize());
        }
        if ((accessToken = successResponse.getAccessToken()) != null) {
            credentials.setAccessTokenObject(accessToken);
        }
        if (code == null && idToken == null && accessToken == null) {
            throw new TechnicalException("Cannot accept empty OIDC credentials");
        }
        return Optional.of(credentials);
    }

    protected Map<String, List<String>> retrieveParameters(WebContext context) {
        Map requestParameters = context.getRequestParameters();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            map.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
        }
        return map;
    }
}

