/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.client;

import java.util.List;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Mechanism;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.credentials.OpenIdCredentials;

public abstract class BaseOpenIdClient<U extends CommonProfile>
extends BaseClient<OpenIdCredentials, U> {
    private static final String OPENID_MODE = "openid.mode";
    private static final String CANCEL_MODE = "cancel";
    public static final String DISCOVERY_INFORMATION = "discoveryInformation";
    private ConsumerManager consumerManager;

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        this.consumerManager = new ConsumerManager();
    }

    protected abstract String getUser(WebContext var1);

    protected String getDiscoveryInformationSessionAttributeName() {
        return this.getName() + "#" + DISCOVERY_INFORMATION;
    }

    protected abstract FetchRequest getFetchRequest() throws MessageException;

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        String userIdentifier = this.getUser(context);
        CommonHelper.assertNotBlank((String)"openIdUser", (String)userIdentifier);
        try {
            List discoveries = this.consumerManager.discover(userIdentifier);
            DiscoveryInformation discoveryInformation = this.consumerManager.associate(discoveries);
            context.setSessionAttribute(this.getDiscoveryInformationSessionAttributeName(), (Object)discoveryInformation);
            String contextualCallbackUrl = this.getContextualCallbackUrl(context);
            AuthRequest authRequest = this.consumerManager.authenticate(discoveryInformation, contextualCallbackUrl);
            FetchRequest fetchRequest = this.getFetchRequest();
            if (fetchRequest != null) {
                authRequest.addExtension((MessageExtension)fetchRequest);
            }
            String redirectionUrl = authRequest.getDestinationUrl(true);
            logger.debug("redirectionUrl : {}", (Object)redirectionUrl);
            return RedirectAction.redirect((String)redirectionUrl);
        }
        catch (OpenIDException e) {
            logger.error("OpenID exception", (Throwable)e);
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
    }

    protected boolean isDirectRedirection() {
        return false;
    }

    protected OpenIdCredentials retrieveCredentials(WebContext context) {
        String mode = context.getRequestParameter(OPENID_MODE);
        if (CommonHelper.areEquals((String)mode, (String)CANCEL_MODE)) {
            logger.debug("authentication cancelled");
            return null;
        }
        ParameterList parameterList = new ParameterList(context.getRequestParameters());
        DiscoveryInformation discoveryInformation = (DiscoveryInformation)context.getSessionAttribute(this.getDiscoveryInformationSessionAttributeName());
        OpenIdCredentials credentials = new OpenIdCredentials(discoveryInformation, parameterList, this.getName());
        logger.debug("credentials : {}", (Object)credentials);
        return credentials;
    }

    protected abstract U createProfile(AuthSuccess var1) throws MessageException;

    protected U retrieveUserProfile(OpenIdCredentials credentials, WebContext context) {
        ParameterList parameterList = credentials.getParameterList();
        DiscoveryInformation discoveryInformation = credentials.getDiscoveryInformation();
        logger.debug("parameterList : {}", (Object)parameterList);
        logger.debug("discoveryInformation : {}", (Object)discoveryInformation);
        try {
            String contextualCallbackUrl = this.getContextualCallbackUrl(context);
            VerificationResult verification = this.consumerManager.verify(contextualCallbackUrl, parameterList, discoveryInformation);
            Identifier verified = verification.getVerifiedId();
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                logger.debug("authSuccess : {}", (Object)authSuccess);
                U profile = this.createProfile(authSuccess);
                profile.setId((Object)verified.getIdentifier());
                logger.debug("profile : {}", profile);
                return profile;
            }
        }
        catch (OpenIDException e) {
            logger.error("OpenID exception", (Throwable)e);
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
        String message = "No verifiedId found";
        logger.error("No verifiedId found");
        throw new TechnicalException("No verifiedId found");
    }

    public Mechanism getMechanism() {
        return Mechanism.OPENID_PROTOCOL;
    }
}

