/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.client;

import java.util.List;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.credentials.OpenIdCredentials;

public abstract class BaseOpenIdClient<U extends CommonProfile>
extends IndirectClient<OpenIdCredentials, U> {
    private static final String OPENID_MODE = "openid.mode";
    private static final String CANCEL_MODE = "cancel";
    public static final String DISCOVERY_INFORMATION = "discoveryInformation";
    private ConsumerManager consumerManager;

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        this.consumerManager = new ConsumerManager();
    }

    protected abstract String getUser(WebContext var1);

    protected String getDiscoveryInformationSessionAttributeName() {
        return this.getName() + "#" + DISCOVERY_INFORMATION;
    }

    protected abstract FetchRequest getFetchRequest() throws MessageException;

    protected RedirectAction retrieveRedirectAction(WebContext context) throws HttpAction {
        String userIdentifier = this.getUser(context);
        CommonHelper.assertNotBlank((String)"openIdUser", (String)userIdentifier);
        try {
            List discoveries = this.consumerManager.discover(userIdentifier);
            DiscoveryInformation discoveryInformation = this.consumerManager.associate(discoveries);
            context.setSessionAttribute(this.getDiscoveryInformationSessionAttributeName(), (Object)discoveryInformation);
            AuthRequest authRequest = this.consumerManager.authenticate(discoveryInformation, this.computeFinalCallbackUrl(context));
            FetchRequest fetchRequest = this.getFetchRequest();
            if (fetchRequest != null) {
                authRequest.addExtension((MessageExtension)fetchRequest);
            }
            String redirectionUrl = authRequest.getDestinationUrl(true);
            this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
            return RedirectAction.redirect((String)redirectionUrl);
        }
        catch (OpenIDException e) {
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
    }

    protected OpenIdCredentials retrieveCredentials(WebContext context) throws HttpAction {
        String mode = context.getRequestParameter(OPENID_MODE);
        if (CommonHelper.areEquals((String)mode, (String)CANCEL_MODE)) {
            this.logger.debug("authentication cancelled");
            return null;
        }
        ParameterList parameterList = new ParameterList(context.getRequestParameters());
        DiscoveryInformation discoveryInformation = (DiscoveryInformation)context.getSessionAttribute(this.getDiscoveryInformationSessionAttributeName());
        OpenIdCredentials credentials = new OpenIdCredentials(discoveryInformation, parameterList, this.getName());
        this.logger.debug("credentials: {}", (Object)credentials);
        return credentials;
    }

    protected abstract U createProfile(AuthSuccess var1) throws HttpAction, MessageException;

    protected U retrieveUserProfile(OpenIdCredentials credentials, WebContext context) throws HttpAction {
        ParameterList parameterList = credentials.getParameterList();
        DiscoveryInformation discoveryInformation = credentials.getDiscoveryInformation();
        this.logger.debug("parameterList: {}", (Object)parameterList);
        this.logger.debug("discoveryInformation: {}", (Object)discoveryInformation);
        try {
            VerificationResult verification = this.consumerManager.verify(this.computeFinalCallbackUrl(context), parameterList, discoveryInformation);
            Identifier verified = verification.getVerifiedId();
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                this.logger.debug("authSuccess: {}", (Object)authSuccess);
                U profile = this.createProfile(authSuccess);
                profile.setId((Object)verified.getIdentifier());
                this.logger.debug("profile: {}", profile);
                return profile;
            }
        }
        catch (OpenIDException e) {
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
        String message = "No verifiedId found";
        throw new TechnicalException("No verifiedId found");
    }
}

