/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.client;

import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.client.BaseOpenIdClient;
import org.pac4j.openid.profile.yahoo.YahooOpenIdProfile;

public class YahooOpenIdClient
extends BaseOpenIdClient<YahooOpenIdProfile> {
    public static final String YAHOO_GENERIC_USER_IDENTIFIER = "https://me.yahoo.com";

    @Override
    protected String getUser(WebContext context) {
        return YAHOO_GENERIC_USER_IDENTIFIER;
    }

    @Override
    protected FetchRequest getFetchRequest() throws MessageException {
        FetchRequest fetchRequest = FetchRequest.createFetchRequest();
        fetchRequest.addAttribute("email", "http://axschema.org/contact/email", true);
        fetchRequest.addAttribute("fullname", "http://axschema.org/namePerson", true);
        fetchRequest.addAttribute("language", "http://axschema.org/pref/language", true);
        fetchRequest.addAttribute("picture_url", "http://axschema.org/media/image/default", true);
        this.logger.debug("fetchRequest: {}", (Object)fetchRequest);
        return fetchRequest;
    }

    @Override
    protected YahooOpenIdProfile createProfile(AuthSuccess authSuccess) throws MessageException, HttpAction {
        YahooOpenIdProfile profile = new YahooOpenIdProfile();
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
            FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            for (String name : profile.getAttributesDefinition().getPrimaryAttributes()) {
                profile.addAttribute(name, fetchResp.getAttributeValue(name));
            }
        }
        return profile;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName()});
    }
}

