/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.credentials.authenticator;

import org.openid4java.OpenIDException;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.client.YahooOpenIdClient;
import org.pac4j.openid.credentials.OpenIdCredentials;
import org.pac4j.openid.profile.yahoo.YahooOpenIdProfile;
import org.pac4j.openid.profile.yahoo.YahooOpenIdProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooAuthenticator
implements Authenticator<OpenIdCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(YahooAuthenticator.class);
    private static final ProfileDefinition<YahooOpenIdProfile> PROFILE_DEFINITION = new YahooOpenIdProfileDefinition();
    private YahooOpenIdClient client;

    public YahooAuthenticator(YahooOpenIdClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
    }

    public void validate(OpenIdCredentials credentials, WebContext context) {
        ParameterList parameterList = credentials.getParameterList();
        DiscoveryInformation discoveryInformation = credentials.getDiscoveryInformation();
        logger.debug("parameterList: {}", (Object)parameterList);
        logger.debug("discoveryInformation: {}", (Object)discoveryInformation);
        try {
            VerificationResult verification = this.client.getConsumerManager().verify(this.client.computeFinalCallbackUrl(context), parameterList, discoveryInformation);
            Identifier verified = verification.getVerifiedId();
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                logger.debug("authSuccess: {}", (Object)authSuccess);
                YahooOpenIdProfile profile = this.createProfile(authSuccess);
                profile.setId(verified.getIdentifier());
                logger.debug("profile: {}", (Object)profile);
                credentials.setUserProfile(profile);
                return;
            }
        }
        catch (OpenIDException e) {
            throw new TechnicalException("OpenID exception", (Throwable)e);
        }
        String message = "No verifiedId found";
        throw new TechnicalException("No verifiedId found");
    }

    protected YahooOpenIdProfile createProfile(AuthSuccess authSuccess) throws MessageException {
        YahooOpenIdProfile profile = (YahooOpenIdProfile)PROFILE_DEFINITION.newProfile(new Object[0]);
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
            FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
            for (String name : PROFILE_DEFINITION.getPrimaryAttributes()) {
                PROFILE_DEFINITION.convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, name, (Object)fetchResp.getAttributeValue(name));
            }
        }
        return profile;
    }
}

