/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.ChainingMetadataProvider;
import org.opensaml.saml2.metadata.provider.DOMMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ResourceBackedMetadataProvider;
import org.opensaml.util.resource.ClasspathResource;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Mechanism;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.context.ExtendedSAMLMessageContext;
import org.pac4j.saml.context.Saml2ContextProvider;
import org.pac4j.saml.credentials.Saml2Credentials;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.EncryptionProvider;
import org.pac4j.saml.crypto.SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SamlException;
import org.pac4j.saml.metadata.Saml2MetadataGenerator;
import org.pac4j.saml.profile.Saml2Profile;
import org.pac4j.saml.sso.Saml2AuthnRequestBuilder;
import org.pac4j.saml.sso.Saml2ResponseValidator;
import org.pac4j.saml.sso.Saml2WebSSOProfileHandler;
import org.pac4j.saml.transport.Pac4jHTTPPostDecoder;
import org.pac4j.saml.transport.SimpleResponseAdapter;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Saml2Client
extends BaseClient<Saml2Credentials, Saml2Profile> {
    protected static final Logger logger = LoggerFactory.getLogger(Saml2Client.class);
    public static final String SAML_METADATA_KEY_INFO_GENERATOR = "MetadataKeyInfoGenerator";
    public static final String SAML_RELAY_STATE_ATTRIBUTE = "samlRelayState";
    private String keystorePath;
    private String keystorePassword;
    private String privateKeyPassword;
    private String idpMetadata;
    private String idpMetadataPath;
    private String idpEntityId;
    private String spEntityId;
    private Integer maximumAuthenticationLifetime;
    private CredentialProvider credentialProvider;
    private Saml2ContextProvider contextProvider;
    private Saml2AuthnRequestBuilder authnRequestBuilder;
    private Saml2WebSSOProfileHandler handler;
    private Saml2ResponseValidator responseValidator;
    private SignatureTrustEngineProvider signatureTrustEngineProvider;
    private Decrypter decrypter;
    private String spMetadata;
    private boolean forceAuth = false;
    private String comparisonType = null;
    private String destinationBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String authnContextClassRef = null;
    private String nameIdPolicyFormat = null;

    protected void internalInit() {
        XMLObject md;
        CommonHelper.assertTrue((CommonHelper.isNotBlank((String)this.idpMetadata) || CommonHelper.isNotBlank((String)this.idpMetadataPath) ? 1 : 0) != 0, (String)"Either idpMetadata or idpMetadataPath must be provided");
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        if (!this.callbackUrl.startsWith("http")) {
            throw new TechnicalException("SAML callbackUrl must be absolute");
        }
        if (CommonHelper.isNotBlank((String)this.keystorePath) || CommonHelper.isNotBlank((String)this.keystorePassword) || CommonHelper.isNotBlank((String)this.privateKeyPassword)) {
            CommonHelper.assertNotBlank((String)"keystorePath", (String)this.keystorePath);
            CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.keystorePassword);
            CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.privateKeyPassword);
            this.credentialProvider = new CredentialProvider(this.keystorePath, this.keystorePassword, this.privateKeyPassword);
            this.decrypter = new EncryptionProvider(this.credentialProvider).buildDecrypter();
        }
        try {
            DefaultBootstrap.bootstrap();
            NamedKeyInfoGeneratorManager manager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager();
            X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
            generator.setEmitEntityCertificate(true);
            generator.setEmitEntityCertificateChain(true);
            manager.registerFactory(SAML_METADATA_KEY_INFO_GENERATOR, (KeyInfoGeneratorFactory)generator);
        }
        catch (ConfigurationException e) {
            throw new SamlException("Error bootstrapping OpenSAML", e);
        }
        StaticBasicParserPool parserPool = this.newStaticBasicParserPool();
        AbstractMetadataProvider idpMetadataProvider = this.idpMetadataProvider((ParserPool)parserPool);
        try {
            md = idpMetadataProvider.getMetadata();
        }
        catch (MetadataProviderException e) {
            throw new SamlException("Error initializing idpMetadataProvider", e);
        }
        if (this.idpEntityId == null) {
            this.idpEntityId = this.getIdpEntityId(md);
        }
        Saml2MetadataGenerator metadataGenerator = new Saml2MetadataGenerator();
        if (this.credentialProvider != null) {
            metadataGenerator.setCredentialProvider(this.credentialProvider);
            metadataGenerator.setAuthnRequestSigned(true);
        }
        if (CommonHelper.isBlank((String)this.spEntityId)) {
            this.spEntityId = this.getCallbackUrl();
        }
        metadataGenerator.setEntityId(this.spEntityId);
        metadataGenerator.setAssertionConsumerServiceUrl(this.getCallbackUrl());
        metadataGenerator.setSingleLogoutServiceUrl(this.getCallbackUrl());
        AbstractMetadataProvider spMetadataProvider = metadataGenerator.buildMetadataProvider();
        try {
            spMetadataProvider.initialize();
            this.spMetadata = metadataGenerator.printMetadata();
        }
        catch (MetadataProviderException e) {
            throw new TechnicalException("Error initializing spMetadataProvider", (Throwable)e);
        }
        catch (MarshallingException e) {
            logger.warn("Unable to print SP metadata", (Throwable)e);
        }
        ChainingMetadataProvider metadataManager = new ChainingMetadataProvider();
        try {
            metadataManager.addMetadataProvider((MetadataProvider)idpMetadataProvider);
            metadataManager.addMetadataProvider((MetadataProvider)spMetadataProvider);
        }
        catch (MetadataProviderException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        this.contextProvider = new Saml2ContextProvider((MetadataProvider)metadataManager, this.idpEntityId, this.spEntityId);
        this.authnRequestBuilder = new Saml2AuthnRequestBuilder(this.forceAuth, this.comparisonType, this.destinationBindingType, this.authnContextClassRef, this.nameIdPolicyFormat);
        HTTPPostEncoder encoder = null;
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            encoder = new HTTPPostEncoder(velocityEngine, "/templates/saml2-post-binding.vm");
        } else if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            encoder = new HTTPRedirectDeflateEncoder();
        } else {
            throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
        }
        Pac4jHTTPPostDecoder decoder = new Pac4jHTTPPostDecoder(parserPool);
        this.handler = new Saml2WebSSOProfileHandler(this.credentialProvider, (MessageEncoder)encoder, (MessageDecoder)decoder, parserPool, this.destinationBindingType);
        this.signatureTrustEngineProvider = new SignatureTrustEngineProvider((MetadataProvider)metadataManager);
        this.responseValidator = new Saml2ResponseValidator();
        if (this.maximumAuthenticationLifetime != null) {
            this.responseValidator.setMaximumAuthenticationLifetime(this.maximumAuthenticationLifetime);
        }
    }

    protected BaseClient<Saml2Credentials, Saml2Profile> newClient() {
        Saml2Client client = new Saml2Client();
        client.setKeystorePath(this.keystorePath);
        client.setKeystorePassword(this.keystorePassword);
        client.setPrivateKeyPassword(this.privateKeyPassword);
        client.setIdpMetadata(this.idpMetadata);
        client.setIdpMetadataPath(this.idpMetadataPath);
        client.setIdpEntityId(this.idpEntityId);
        client.setSpEntityId(this.spEntityId);
        client.setMaximumAuthenticationLifetime(this.maximumAuthenticationLifetime);
        client.setCallbackUrl(this.callbackUrl);
        client.setDestinationBindingType(this.destinationBindingType);
        client.setComparisonType(this.comparisonType);
        client.setAuthnContextClassRef(this.authnContextClassRef);
        client.setNameIdPolicyFormat(this.nameIdPolicyFormat);
        return client;
    }

    protected boolean isDirectRedirection() {
        return false;
    }

    protected RedirectAction retrieveRedirectAction(WebContext wc) {
        ExtendedSAMLMessageContext context = this.contextProvider.buildSpAndIdpContext(wc);
        String relayState = this.getStateParameter(wc);
        AuthnRequest authnRequest = this.authnRequestBuilder.build((SAMLMessageContext)context);
        this.handler.sendMessage((SAMLMessageContext)context, authnRequest, relayState);
        if (this.destinationBindingType.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String content = ((SimpleResponseAdapter)context.getOutboundMessageTransport()).getOutgoingContent();
            return RedirectAction.success((String)content);
        }
        String location = ((SimpleResponseAdapter)context.getOutboundMessageTransport()).getRedirectUrl();
        return RedirectAction.redirect((String)location);
    }

    protected Saml2Credentials retrieveCredentials(WebContext wc) throws RequiresHttpAction {
        ExtendedSAMLMessageContext context = this.contextProvider.buildSpContext(wc);
        context.setAssertionConsumerUrl(this.getCallbackUrl());
        SignatureTrustEngine trustEngine = this.signatureTrustEngineProvider.build();
        this.handler.receiveMessage((SAMLMessageContext)context, trustEngine);
        this.responseValidator.validateSamlResponse(context, trustEngine, this.decrypter);
        return this.buildSaml2Credentials(context);
    }

    protected StaticBasicParserPool newStaticBasicParserPool() {
        StaticBasicParserPool parserPool = new StaticBasicParserPool();
        try {
            parserPool.initialize();
        }
        catch (XMLParserException e) {
            throw new SamlException("Error initializing parserPool", e);
        }
        return parserPool;
    }

    protected AbstractMetadataProvider idpMetadataProvider(ParserPool parserPool) {
        DOMMetadataProvider idpMetadataProvider;
        try {
            if (this.idpMetadataPath != null) {
                FilesystemResource resource = null;
                if (this.idpMetadataPath.startsWith("resource:")) {
                    String path = this.idpMetadataPath.substring("resource:".length());
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    resource = new ClasspathResource(path);
                } else {
                    resource = new FilesystemResource(this.idpMetadataPath);
                }
                idpMetadataProvider = new ResourceBackedMetadataProvider(new Timer(true), (Resource)resource);
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(this.idpMetadata.getBytes());
                Document inCommonMDDoc = parserPool.parse((InputStream)in);
                Element metadataRoot = inCommonMDDoc.getDocumentElement();
                idpMetadataProvider = new DOMMetadataProvider(metadataRoot);
            }
            idpMetadataProvider.setParserPool(parserPool);
            idpMetadataProvider.initialize();
        }
        catch (MetadataProviderException e) {
            throw new SamlException("Error initializing idpMetadataProvider", e);
        }
        catch (XMLParserException e) {
            throw new TechnicalException("Error parsing idp Metadata", (Throwable)e);
        }
        catch (ResourceException e) {
            throw new TechnicalException("Error getting idp Metadata resource", (Throwable)e);
        }
        return idpMetadataProvider;
    }

    protected XMLObject getXmlObject(AbstractMetadataProvider idpMetadataProvider) {
        try {
            return idpMetadataProvider.getMetadata();
        }
        catch (MetadataProviderException e) {
            throw new SamlException("Error initializing idpMetadataProvider", e);
        }
    }

    protected String getIdpEntityId(XMLObject md) {
        if (md instanceof EntitiesDescriptor) {
            Iterator iterator = ((EntitiesDescriptor)md).getEntityDescriptors().iterator();
            if (iterator.hasNext()) {
                EntityDescriptor entity = (EntityDescriptor)iterator.next();
                return entity.getEntityID();
            }
        } else if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SamlException("No idp entityId found");
    }

    private Saml2Credentials buildSaml2Credentials(ExtendedSAMLMessageContext context) {
        NameID nameId = (NameID)context.getSubjectNameIdentifier();
        Assertion subjectAssertion = context.getSubjectAssertion();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attributeStatement : subjectAssertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                attributes.add(attribute);
            }
            if (attributeStatement.getEncryptedAttributes().size() <= 0) continue;
            if (this.decrypter == null) {
                logger.warn("Encrypted attributes returned, but no keystore was provided.");
                continue;
            }
            for (EncryptedAttribute encryptedAttribute : attributeStatement.getEncryptedAttributes()) {
                try {
                    attributes.add(this.decrypter.decrypt(encryptedAttribute));
                }
                catch (DecryptionException e) {
                    logger.warn("Decryption of attribute failed, continue with the next one", (Throwable)e);
                }
            }
        }
        return new Saml2Credentials(nameId, attributes, subjectAssertion.getConditions(), this.getName());
    }

    protected Saml2Profile retrieveUserProfile(Saml2Credentials credentials, WebContext context) {
        Saml2Profile profile = new Saml2Profile();
        profile.setId(credentials.getNameId().getValue());
        for (Attribute attribute : credentials.getAttributes()) {
            ArrayList<String> values = new ArrayList<String>();
            for (XMLObject attributeValue : attribute.getAttributeValues()) {
                Element attributeValueElement = attributeValue.getDOM();
                String value = attributeValueElement.getTextContent();
                values.add(value);
            }
            profile.addAttribute(attribute.getName(), values);
        }
        return profile;
    }

    protected String getStateParameter(WebContext webContext) {
        String relayState = (String)webContext.getSessionAttribute(SAML_RELAY_STATE_ATTRIBUTE);
        return relayState == null ? this.getContextualCallbackUrl(webContext) : relayState;
    }

    public Mechanism getMechanism() {
        return Mechanism.SAML_PROTOCOL;
    }

    public void setIdpMetadata(String idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    public void setIdpMetadataPath(String idpMetadataPath) {
        this.idpMetadataPath = idpMetadataPath;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public void setMaximumAuthenticationLifetime(Integer maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public String printClientMetadata() {
        this.init();
        return this.spMetadata;
    }

    public boolean isForceAuth() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    public String getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getDestinationBindingType() {
        return this.destinationBindingType;
    }

    public void setDestinationBindingType(String destinationBindingType) {
        this.destinationBindingType = destinationBindingType;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }
}

