/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SamlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProvider {
    private final Logger logger = LoggerFactory.getLogger(CredentialProvider.class);
    private final CredentialResolver credentialResolver;
    private final String privateKey;

    public CredentialProvider(String name, String storePasswd, String privateKeyPasswd) {
        InputStream inputStream = CommonHelper.getInputStreamFromName((String)name);
        KeyStore keyStore = this.loadKeyStore(inputStream, storePasswd);
        this.privateKey = this.getPrivateKeyAlias(keyStore);
        HashMap<String, String> passwords = new HashMap<String, String>();
        passwords.put(this.privateKey, privateKeyPasswd);
        this.credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
    }

    public Credential getCredential() {
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIDCriteria criteria = new EntityIDCriteria(this.privateKey);
            cs.add((Object)criteria);
            return (Credential)this.credentialResolver.resolveSingle((Object)cs);
        }
        catch (SecurityException e) {
            throw new SamlException("Can't obtain SP private key", e);
        }
    }

    private KeyStore loadKeyStore(InputStream inputStream, String storePasswd) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(inputStream, storePasswd == null ? null : storePasswd.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            this.logger.error("Error loading keystore", (Throwable)e);
            throw new SamlException("Error loading keystore", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.debug("Error closing input stream of keystore", (Throwable)e);
                }
            }
        }
    }

    private String getPrivateKeyAlias(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                return aliases.nextElement();
            }
            throw new SamlException("Keystore has no private keys");
        }
        catch (KeyStoreException e) {
            throw new SamlException("Unable to get aliases from keyStore", e);
        }
    }
}

