/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.util.Collection;
import java.util.LinkedList;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.util.XMLHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SamlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Saml2MetadataGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(Saml2MetadataGenerator.class);
    protected XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    protected MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
    protected CredentialProvider credentialProvider;
    protected String entityId;
    protected String assertionConsumerServiceUrl;
    protected String singleLogoutServiceUrl;
    protected boolean authnRequestSigned = false;
    protected boolean wantAssertionSigned = true;
    protected int defaultACSIndex = 0;

    public AbstractMetadataProvider buildMetadataProvider() {
        final EntityDescriptor md = this.buildMetadata();
        return new AbstractMetadataProvider(){

            protected XMLObject doGetMetadata() throws MetadataProviderException {
                return md;
            }
        };
    }

    public String printMetadata() throws MarshallingException {
        EntityDescriptor md = this.buildMetadata();
        Element entityDescriptorElement = this.marshallerFactory.getMarshaller((XMLObject)md).marshall((XMLObject)md);
        return XMLHelper.nodeToString((Node)entityDescriptorElement);
    }

    public EntityDescriptor buildMetadata() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor descriptor = (EntityDescriptor)builder.buildObject();
        descriptor.setEntityID(this.entityId);
        descriptor.getRoleDescriptors().add(this.buildSPSSODescriptor());
        return descriptor;
    }

    protected KeyInfo generateKeyInfoForCredential(Credential credential) {
        try {
            KeyInfoGenerator keyInfoGenerator = SecurityHelper.getKeyInfoGenerator((Credential)credential, null, (String)"MetadataKeyInfoGenerator");
            return keyInfoGenerator.generate(credential);
        }
        catch (SecurityException e) {
            throw new SamlException("Unable to generate keyInfo from given credential", e);
        }
    }

    protected SPSSODescriptor buildSPSSODescriptor() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        SPSSODescriptor spDescriptor = (SPSSODescriptor)builder.buildObject();
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(this.authnRequestSigned));
        spDescriptor.setWantAssertionsSigned(Boolean.valueOf(this.wantAssertionSigned));
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spDescriptor.getNameIDFormats().addAll(this.buildNameIDFormat());
        int index = 0;
        spDescriptor.getAssertionConsumerServices().add(this.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", index++, this.defaultACSIndex == index));
        if (this.credentialProvider != null) {
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.SIGNING, this.getKeyInfo()));
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.ENCRYPTION, this.getKeyInfo()));
        }
        return spDescriptor;
    }

    protected Collection<NameIDFormat> buildNameIDFormat() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME);
        LinkedList<NameIDFormat> formats = new LinkedList<NameIDFormat>();
        NameIDFormat transientNameID = (NameIDFormat)builder.buildObject();
        transientNameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        formats.add(transientNameID);
        NameIDFormat persistentNameID = (NameIDFormat)builder.buildObject();
        persistentNameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        formats.add(persistentNameID);
        NameIDFormat emailNameID = (NameIDFormat)builder.buildObject();
        emailNameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        formats.add(emailNameID);
        NameIDFormat unspecNameID = (NameIDFormat)builder.buildObject();
        unspecNameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        formats.add(unspecNameID);
        return formats;
    }

    protected AssertionConsumerService getAssertionConsumerService(String binding, int index, boolean isDefault) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        AssertionConsumerService consumer = (AssertionConsumerService)builder.buildObject();
        consumer.setLocation(this.assertionConsumerServiceUrl);
        consumer.setBinding(binding);
        if (isDefault) {
            consumer.setIsDefault(Boolean.valueOf(true));
        }
        consumer.setIndex(Integer.valueOf(index));
        return consumer;
    }

    protected SingleLogoutService getSingleLogoutService(String binding) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        SingleLogoutService logoutService = (SingleLogoutService)builder.buildObject();
        logoutService.setLocation(this.singleLogoutServiceUrl);
        logoutService.setBinding(binding);
        return logoutService;
    }

    protected KeyDescriptor getKeyDescriptor(UsageType type, KeyInfo key) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyDescriptor descriptor = (KeyDescriptor)builder.buildObject();
        descriptor.setUse(type);
        descriptor.setKeyInfo(key);
        return descriptor;
    }

    private KeyInfo getKeyInfo() {
        Credential serverCredential = this.credentialProvider.getCredential();
        return this.generateKeyInfoForCredential(serverCredential);
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public boolean isWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    public void setWantAssertionSigned(boolean wantAssertionSigned) {
        this.wantAssertionSigned = wantAssertionSigned;
    }

    public int getDefaultACSIndex() {
        return this.defaultACSIndex;
    }

    public void setDefaultACSIndex(int defaultACSIndex) {
        this.defaultACSIndex = defaultACSIndex;
    }

    public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.singleLogoutServiceUrl = singleLogoutServiceUrl;
    }
}

