/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso;

import java.util.Random;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.pac4j.saml.util.SamlUtils;

public class Saml2AuthnRequestBuilder {
    private boolean forceAuth;
    private AuthnContextComparisonTypeEnumeration comparisonType;
    private String bindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String authnContextClassRef = null;
    private String nameIdPolicyFormat = null;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public Saml2AuthnRequestBuilder() {
    }

    public Saml2AuthnRequestBuilder(boolean forceAuth, String comparisonType, String bindingType, String authnContextClassRef, String nameIdPolicyFormat) {
        this.forceAuth = forceAuth;
        this.comparisonType = this.getComparisonTypeEnumFromString(comparisonType);
        this.bindingType = bindingType;
        this.authnContextClassRef = authnContextClassRef;
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public AuthnRequest build(SAMLMessageContext context) {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)context.getPeerEntityRoleMetadata();
        SingleSignOnService ssoService = SamlUtils.getSingleSignOnService(idpssoDescriptor, this.bindingType);
        AssertionConsumerService assertionConsumerService = SamlUtils.getAssertionConsumerService(spDescriptor, null);
        return this.buildAuthnRequest(context, assertionConsumerService, ssoService);
    }

    protected AuthnRequest buildAuthnRequest(SAMLMessageContext context, AssertionConsumerService assertionConsumerService, SingleSignOnService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        if (this.comparisonType != null) {
            RequestedAuthnContext authnContext = new RequestedAuthnContextBuilder().buildObject();
            authnContext.setComparison(this.comparisonType);
            if (this.authnContextClassRef != null) {
                AuthnContextClassRef classRef = new AuthnContextClassRefBuilder().buildObject();
                classRef.setAuthnContextClassRef(this.authnContextClassRef);
                authnContext.getAuthnContextClassRefs().add(classRef);
            }
            request.setRequestedAuthnContext(authnContext);
        }
        request.setID(this.generateID());
        request.setIssuer(this.getIssuer(context.getLocalEntityId()));
        request.setIssueInstant(new DateTime());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIsPassive(Boolean.valueOf(false));
        request.setForceAuthn(Boolean.valueOf(this.forceAuth));
        request.setProviderName("pac4j-saml");
        if (this.nameIdPolicyFormat != null) {
            NameIDPolicy nameIdPolicy = new NameIDPolicyBuilder().buildObject();
            nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
            nameIdPolicy.setFormat(this.nameIdPolicyFormat);
            request.setNameIDPolicy(nameIdPolicy);
        }
        request.setDestination(ssoService.getLocation());
        request.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        request.setProtocolBinding(assertionConsumerService.getBinding());
        return request;
    }

    protected Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    protected String generateID() {
        Random r = new Random();
        return '_' + Long.toString(Math.abs(r.nextLong()), 16) + Long.toString(Math.abs(r.nextLong()), 16);
    }

    protected AuthnContextComparisonTypeEnumeration getComparisonTypeEnumFromString(String comparisonType) {
        if ("exact".equals(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.EXACT;
        }
        if ("minimum".equals(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MINIMUM;
        }
        if ("maximum".equals(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MAXIMUM;
        }
        if ("better".equals(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.BETTER;
        }
        return null;
    }
}

