/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.util.List;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.pac4j.saml.exceptions.SamlException;

public class SamlUtils {
    public static SingleSignOnService getSingleSignOnService(IDPSSODescriptor idpssoDescriptor, String binding) {
        List services = idpssoDescriptor.getSingleSignOnServices();
        for (SingleSignOnService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service;
        }
        throw new SamlException("Identity provider has no single sign on service available for the selected profile" + idpssoDescriptor);
    }

    public static AssertionConsumerService getAssertionConsumerService(SPSSODescriptor spDescriptor, Integer acsIndex) {
        List services = spDescriptor.getAssertionConsumerServices();
        if (acsIndex != null) {
            for (AssertionConsumerService service : services) {
                if (!acsIndex.equals(service.getIndex())) continue;
                return service;
            }
            throw new SamlException("Assertion consumer service with index " + acsIndex + " could not be found for spDescriptor " + spDescriptor);
        }
        if (spDescriptor.getDefaultAssertionConsumerService() != null) {
            return spDescriptor.getDefaultAssertionConsumerService();
        }
        if (services.size() > 0) {
            return (AssertionConsumerService)services.iterator().next();
        }
        throw new SamlException("No assertion consumer services could be found for " + spDescriptor);
    }
}

