/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.URIComparator;
import net.shibboleth.utilities.java.support.net.impl.BasicURLComparator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.MessageReplaySecurityHandler;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLEndpointMismatchException;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.exceptions.SAMLIssueInstantException;
import org.pac4j.saml.exceptions.SAMLIssuerException;
import org.pac4j.saml.exceptions.SAMLNameIdDecryptionException;
import org.pac4j.saml.exceptions.SAMLReplayException;
import org.pac4j.saml.exceptions.SAMLSignatureValidationException;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2ResponseValidator
implements SAML2ResponseValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected final URIComparator uriComparator;
    protected final Decrypter decrypter;
    protected final LogoutHandler logoutHandler;
    protected final ReplayCacheProvider replayCache;
    protected int acceptedSkew = 120;

    protected AbstractSAML2ResponseValidator(SAML2SignatureTrustEngineProvider signatureTrustEngineProvider, Decrypter decrypter, LogoutHandler logoutHandler, ReplayCacheProvider replayCache) {
        this(signatureTrustEngineProvider, decrypter, logoutHandler, replayCache, (URIComparator)new BasicURLComparator());
    }

    protected AbstractSAML2ResponseValidator(SAML2SignatureTrustEngineProvider signatureTrustEngineProvider, Decrypter decrypter, LogoutHandler logoutHandler, ReplayCacheProvider replayCache, URIComparator uriComparator) {
        this.signatureTrustEngineProvider = signatureTrustEngineProvider;
        this.decrypter = decrypter;
        this.logoutHandler = logoutHandler;
        this.replayCache = replayCache;
        this.uriComparator = uriComparator;
    }

    protected void validateSuccess(Status status) {
        Object statusValue = status.getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusValue)) {
            StatusMessage statusMessage = status.getStatusMessage();
            if (statusMessage != null) {
                statusValue = (String)statusValue + " / " + statusMessage.getValue();
            }
            throw new SAMLException("Response is not success ; actual " + (String)statusValue);
        }
    }

    protected void validateSignatureIfItExists(Signature signature, SAML2MessageContext context, SignatureTrustEngine engine) {
        if (signature != null) {
            String entityId = context.getSAMLPeerEntityContext().getEntityId();
            this.validateSignature(signature, entityId, engine);
            context.getSAMLPeerEntityContext().setAuthenticated(true);
            this.logger.debug("Successfully validated signature for entity id {}", (Object)entityId);
        } else {
            this.logger.debug("Cannot locate a signature from the message; skipping validation");
        }
    }

    protected void validateSignature(Signature signature, String idpEntityId, SignatureTrustEngine trustEngine) {
        boolean valid;
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            this.logger.debug("Validating profile signature for entity id {}", (Object)idpEntityId);
            validator.validate(signature);
        }
        catch (SignatureException e) {
            throw new SAMLSignatureValidationException("SAMLSignatureProfileValidator failed to validate signature", e);
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new EntityIdCriterion(idpEntityId));
        try {
            this.logger.debug("Validating signature via trust engine for entity id {}", (Object)idpEntityId);
            valid = trustEngine.validate((Object)signature, criteriaSet);
        }
        catch (SecurityException e) {
            throw new SAMLSignatureValidationException("An error occurred during signature validation", e);
        }
        if (!valid) {
            throw new SAMLSignatureValidationException("Signature is not trusted");
        }
    }

    protected void validateIssuerIfItExists(Issuer isser, SAML2MessageContext context) {
        if (isser != null) {
            this.validateIssuer(isser, context);
        }
    }

    protected void validateIssuer(Issuer issuer, SAML2MessageContext context) {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLIssuerException("Issuer type is not entity but " + issuer.getFormat());
        }
        String entityId = context.getSAMLPeerEntityContext().getEntityId();
        this.logger.debug("Comparing issuer {} against {}", (Object)issuer.getValue(), (Object)entityId);
        if (entityId == null || !entityId.equals(issuer.getValue())) {
            throw new SAMLIssuerException("Issuer " + issuer.getValue() + " does not match idp entityId " + entityId);
        }
    }

    protected void validateIssueInstant(Instant issueInstant) {
        if (!this.isIssueInstantValid(issueInstant)) {
            throw new SAMLIssueInstantException("Issue instant is too old or in the future");
        }
    }

    protected boolean isIssueInstantValid(Instant issueInstant) {
        return this.isDateValid(issueInstant, 0);
    }

    protected boolean isDateValid(Instant issueInstant, int interval) {
        boolean isDateValid;
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime before = now.plusSeconds(this.acceptedSkew);
        ZonedDateTime after = now.minusSeconds(this.acceptedSkew + interval);
        ZonedDateTime issueInstanceUtc = ZonedDateTime.ofInstant(issueInstant, ZoneOffset.UTC);
        boolean bl = isDateValid = issueInstanceUtc.isBefore(before) && issueInstanceUtc.isAfter(after);
        if (!isDateValid) {
            this.logger.warn("interval={},before={},after={},issueInstant={}", new Object[]{interval, before, after, issueInstanceUtc});
        }
        return isDateValid;
    }

    protected void verifyEndpoint(Endpoint endpoint, String destination) {
        try {
            if (destination != null && !this.uriComparator.compare(destination, endpoint.getLocation()) && !this.uriComparator.compare(destination, endpoint.getResponseLocation())) {
                throw new SAMLEndpointMismatchException("Intended destination " + destination + " doesn't match any of the endpoint URLs on endpoint " + endpoint.getLocation());
            }
        }
        catch (Exception e) {
            throw new SAMLEndpointMismatchException(e);
        }
    }

    protected void verifyMessageReplay(SAML2MessageContext context) {
        if (this.replayCache == null) {
            this.logger.warn("No replay cache specified, skipping replay verification");
            return;
        }
        try {
            MessageReplaySecurityHandler messageReplayHandler = new MessageReplaySecurityHandler();
            messageReplayHandler.setExpires(Duration.ofMillis(this.acceptedSkew * 1000));
            messageReplayHandler.setReplayCache(this.replayCache.get());
            messageReplayHandler.initialize();
            messageReplayHandler.invoke(context.getMessageContext());
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException(e);
        }
        catch (MessageHandlerException e) {
            throw new SAMLReplayException(e);
        }
    }

    protected NameID decryptEncryptedId(EncryptedID encryptedId, Decrypter decrypter) throws SAMLException {
        if (encryptedId == null) {
            return null;
        }
        if (decrypter == null) {
            this.logger.warn("Encrypted attributes returned, but no keystore was provided.");
            return null;
        }
        try {
            this.logger.debug("Decrypting name id {}", (Object)encryptedId);
            NameID decryptedId = (NameID)decrypter.decrypt(encryptedId);
            return decryptedId;
        }
        catch (DecryptionException e) {
            throw new SAMLNameIdDecryptionException("Decryption of an EncryptedID failed.", e);
        }
    }

    protected String computeSloKey(String sessionIndex, NameID nameId) {
        if (sessionIndex != null) {
            return sessionIndex;
        }
        if (nameId != null) {
            return nameId.getValue();
        }
        return null;
    }

    @Override
    public final void setAcceptedSkew(int acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }
}

