/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.artifact;

import java.util.Optional;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.profile.impl.AbstractSAML2MessageReceiver;
import org.pac4j.saml.sso.artifact.SAML2ArtifactBindingDecoder;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.transport.AbstractPac4jDecoder;
import org.pac4j.saml.util.Configuration;

public class SAML2ArtifactBindingMessageReceiver
extends AbstractSAML2MessageReceiver {
    private static final String SAML2_WEBSSO_PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    private SAML2MetadataResolver idpMetadataResolver;
    private SAML2MetadataResolver spMetadataResolver;
    private SOAPPipelineProvider soapPipelineProvider;

    public SAML2ArtifactBindingMessageReceiver(SAML2ResponseValidator validator, SAML2MetadataResolver idpMetadataResolver, SAML2MetadataResolver spMetadataResolver, SOAPPipelineProvider soapPipelineProvider) {
        super(validator);
        this.idpMetadataResolver = idpMetadataResolver;
        this.spMetadataResolver = spMetadataResolver;
        this.soapPipelineProvider = soapPipelineProvider;
    }

    @Override
    protected Optional<Endpoint> getEndpoint(SAML2MessageContext context, StatusResponseType response) {
        return Optional.of(context.getSPAssertionConsumerService(response));
    }

    @Override
    protected AbstractPac4jDecoder getDecoder(WebContext webContext) {
        SAML2ArtifactBindingDecoder decoder = new SAML2ArtifactBindingDecoder(webContext, this.idpMetadataResolver, this.spMetadataResolver, this.soapPipelineProvider);
        try {
            decoder.setParserPool(Configuration.getParserPool());
            decoder.initialize();
            decoder.decode();
        }
        catch (Exception e) {
            throw new SAMLException("Error decoding SAML message", e);
        }
        return decoder;
    }

    @Override
    protected String getProfileUri() {
        return SAML2_WEBSSO_PROFILE_URI;
    }
}

