/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.pac4j.saml.context.SAML2ConfigurationContext;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.api.SAML2ObjectBuilder;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2AuthnRequestBuilder
implements SAML2ObjectBuilder<AuthnRequest> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int issueInstantSkewSeconds = 0;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    @Override
    public AuthnRequest build(SAML2MessageContext context) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        SingleSignOnService ssoService = context.getIDPSingleSignOnService(configContext.getAuthnRequestBindingType());
        String idx = configContext.getAssertionConsumerServiceIndex() > 0 ? String.valueOf(configContext.getAssertionConsumerServiceIndex()) : null;
        AssertionConsumerService assertionConsumerService = context.getSPAssertionConsumerService(idx);
        AuthnRequest authnRequest = this.buildAuthnRequest(context, assertionConsumerService, ssoService);
        SAML2Utils.logProtocolMessage((XMLObject)authnRequest);
        return authnRequest;
    }

    protected final AuthnRequest buildAuthnRequest(SAML2MessageContext context, AssertionConsumerService assertionConsumerService, SingleSignOnService ssoService) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        AuthnContextComparisonTypeEnumeration comparisonType = this.getComparisonTypeEnumFromString(configContext.getComparisonType());
        if (comparisonType != null) {
            RequestedAuthnContext authnContext = new RequestedAuthnContextBuilder().buildObject();
            authnContext.setComparison(comparisonType);
            if (configContext.getAuthnContextClassRefs() != null && !configContext.getAuthnContextClassRefs().isEmpty()) {
                List refs = authnContext.getAuthnContextClassRefs();
                configContext.getAuthnContextClassRefs().forEach(r -> refs.add(this.buildAuthnContextClassRef((String)r)));
            }
            request.setRequestedAuthnContext(authnContext);
        }
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(SAML2Utils.generateID());
        request.setIssuer(this.getIssuer(context, selfContext.getEntityId()));
        request.setIssueInstant(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(this.issueInstantSkewSeconds).toInstant());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIsPassive(configContext.isPassive());
        request.setForceAuthn(configContext.isForceAuth());
        if (StringUtils.isNotBlank((CharSequence)configContext.getProviderName())) {
            request.setProviderName(configContext.getProviderName());
        }
        if (configContext.getNameIdPolicyFormat() != null) {
            NameIDPolicy nameIdPolicy = new NameIDPolicyBuilder().buildObject();
            if (configContext.isNameIdPolicyAllowCreate() != null) {
                nameIdPolicy.setAllowCreate(configContext.isNameIdPolicyAllowCreate());
            }
            nameIdPolicy.setFormat(configContext.getNameIdPolicyFormat());
            request.setNameIDPolicy(nameIdPolicy);
        }
        request.setDestination(ssoService.getLocation());
        if (configContext.getAssertionConsumerServiceIndex() >= 0) {
            request.setAssertionConsumerServiceIndex(configContext.getAssertionConsumerServiceIndex());
        } else {
            request.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        }
        request.setProtocolBinding(assertionConsumerService.getBinding());
        if (configContext.getAttributeConsumingServiceIndex() >= 0) {
            request.setAttributeConsumingServiceIndex(configContext.getAttributeConsumingServiceIndex());
        }
        Extensions extensions = (Extensions)((SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME)).buildObject();
        if (!configContext.getSAML2Configuration().getRequestedServiceProviderAttributes().isEmpty()) {
            SAMLObjectBuilder attrBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestedAttribute.DEFAULT_ELEMENT_NAME);
            configContext.getSAML2Configuration().getRequestedServiceProviderAttributes().forEach(attribute -> {
                RequestedAttribute requestAttribute = (RequestedAttribute)attrBuilder.buildObject(RequestedAttribute.DEFAULT_ELEMENT_NAME);
                requestAttribute.setIsRequired(Boolean.valueOf(attribute.isRequired()));
                requestAttribute.setName(attribute.getName());
                requestAttribute.setFriendlyName(attribute.getFriendlyName());
                requestAttribute.setNameFormat(attribute.getNameFormat());
                extensions.getUnknownXMLObjects().add(requestAttribute);
            });
        }
        if (configContext.getSAML2Configuration().getAuthnRequestExtensions() != null) {
            extensions.getUnknownXMLObjects().addAll((Collection)configContext.getSAML2Configuration().getAuthnRequestExtensions().get());
        }
        if (!extensions.getUnknownXMLObjects().isEmpty()) {
            request.setExtensions(extensions);
        }
        return request;
    }

    protected AuthnContextClassRef buildAuthnContextClassRef(String authnContextClassRef) {
        AuthnContextClassRef classRef = new AuthnContextClassRefBuilder().buildObject();
        classRef.setURI(authnContextClassRef);
        return classRef;
    }

    protected final Issuer getIssuer(SAML2MessageContext context, String spEntityId) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        String issuerFormat = configContext.getIssuerFormat();
        if (issuerFormat != null) {
            issuer.setFormat(issuerFormat);
        }
        if (configContext.isUseNameQualifier().booleanValue()) {
            issuer.setNameQualifier(spEntityId);
        }
        return issuer;
    }

    protected AuthnContextComparisonTypeEnumeration getComparisonTypeEnumFromString(String comparisonType) {
        if ("exact".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.EXACT;
        }
        if ("minimum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MINIMUM;
        }
        if ("maximum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MAXIMUM;
        }
        if ("better".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.BETTER;
        }
        return null;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

