/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ConfigurationContext;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMAssertionSubjectException;
import org.pac4j.saml.exceptions.SAMLAssertionAudienceException;
import org.pac4j.saml.exceptions.SAMLAssertionConditionException;
import org.pac4j.saml.exceptions.SAMLAuthnContextClassRefException;
import org.pac4j.saml.exceptions.SAMLAuthnInstantException;
import org.pac4j.saml.exceptions.SAMLAuthnSessionCriteriaException;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.exceptions.SAMLInResponseToMismatchException;
import org.pac4j.saml.exceptions.SAMLReplayException;
import org.pac4j.saml.exceptions.SAMLSignatureRequiredException;
import org.pac4j.saml.exceptions.SAMLSignatureValidationException;
import org.pac4j.saml.exceptions.SAMLSubjectConfirmationException;
import org.pac4j.saml.profile.impl.AbstractSAML2ResponseValidator;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2AuthnResponseValidator
extends AbstractSAML2ResponseValidator {
    public SAML2AuthnResponseValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, ReplayCacheProvider replayCache, SAML2Configuration saml2Configuration) {
        super(engine, decrypter, saml2Configuration.getLogoutHandler(), replayCache, saml2Configuration.getUriComparator());
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessageContext().getMessage();
        if (!(message instanceof Response)) {
            throw new SAMLException("Must be a Response type");
        }
        Response response = (Response)message;
        SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
        this.verifyMessageReplay(context);
        this.validateSamlProtocolResponse(response, context, engine);
        if (this.decrypter != null) {
            this.decryptEncryptedAssertions(response, this.decrypter);
        }
        this.validateSamlSSOResponse(response, context, engine, this.decrypter);
        return this.buildSAML2Credentials(context);
    }

    protected SAML2Credentials buildSAML2Credentials(SAML2MessageContext context) {
        Assertion subjectAssertion = context.getSubjectAssertion();
        List<Attribute> attributes = this.collectAssertionAttributes(subjectAssertion);
        SAML2Credentials.SAMLNameID samlNameId = this.determineNameID(context, SAML2Credentials.SAMLAttribute.from(attributes));
        String sessionIndex = this.getSessionIndex(subjectAssertion);
        String sloKey = this.computeSloKey(sessionIndex, samlNameId);
        if (sloKey != null) {
            this.logoutHandler.recordSession(context.getWebContext(), context.getSessionStore(), sloKey);
        }
        String issuerEntityId = subjectAssertion.getIssuer().getValue();
        List authnStatements = subjectAssertion.getAuthnStatements();
        ArrayList<String> authnContexts = new ArrayList<String>();
        for (AuthnStatement authnStatement : authnStatements) {
            if (authnStatement.getAuthnContext().getAuthnContextClassRef() == null) continue;
            authnContexts.add(authnStatement.getAuthnContext().getAuthnContextClassRef().getURI());
        }
        return new SAML2Credentials(samlNameId, issuerEntityId, SAML2Credentials.SAMLAttribute.from(attributes), subjectAssertion.getConditions(), sessionIndex, authnContexts);
    }

    protected List<Attribute> collectAssertionAttributes(Assertion subjectAssertion) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement attributeStatement : subjectAssertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                attributes.add(attribute);
            }
            if (attributeStatement.getEncryptedAttributes().isEmpty()) continue;
            if (this.decrypter == null) {
                this.logger.warn("Encrypted attributes returned, but no keystore was provided.");
                continue;
            }
            for (EncryptedAttribute encryptedAttribute : attributeStatement.getEncryptedAttributes()) {
                try {
                    attributes.add(this.decrypter.decrypt(encryptedAttribute));
                }
                catch (DecryptionException e) {
                    this.logger.warn("Decryption of attribute failed, continue with the next one", (Throwable)e);
                }
            }
        }
        return attributes;
    }

    protected SAML2Credentials.SAMLNameID determineNameID(SAML2MessageContext context, List<SAML2Credentials.SAMLAttribute> attributes) {
        Object nameId;
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        if (configContext.getNameIdAttribute() != null && ((Optional)(nameId = attributes.stream().filter(attribute -> attribute.getName().equals(configContext.getNameIdAttribute())).findFirst().map(SAML2Credentials.SAMLNameID::from))).isPresent()) {
            return (SAML2Credentials.SAMLNameID)((Optional)nameId).get();
        }
        nameId = Objects.requireNonNull(context.getSAMLSubjectNameIdentifierContext().getSAML2SubjectNameID());
        return SAML2Credentials.SAMLNameID.from((NameID)nameId);
    }

    protected String getSessionIndex(Assertion subjectAssertion) {
        AuthnStatement statement;
        List authnStatements = subjectAssertion.getAuthnStatements();
        if (authnStatements != null && !authnStatements.isEmpty() && (statement = (AuthnStatement)authnStatements.get(0)) != null) {
            return statement.getSessionIndex();
        }
        return null;
    }

    protected void validateSamlProtocolResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        this.validateSuccess(response.getStatus());
        if (!response.getVersion().equals(SAMLVersion.VERSION_20)) {
            throw new SAMLException("Invalid SAML version assigned to the response " + response.getVersion());
        }
        if (configContext.isWantsResponsesSigned() && response.getSignature() == null) {
            this.logger.debug("Unable to find a signature on the SAML response returned. Pac4j is configured to enforce signatures on SAML2 responses from identity providers and the returned response\n{}\ndoes not contain any signature", (Object)Configuration.serializeSamlObject((XMLObject)response));
            throw new SAMLSignatureValidationException("Unable to find a signature on the SAML response returned");
        }
        this.validateSignatureIfItExists(response.getSignature(), context, engine);
        this.validateIssueInstant(response.getIssueInstant());
        AuthnRequest request = null;
        SAMLMessageStore messageStorage = context.getSAMLMessageStore();
        if (messageStorage != null && response.getInResponseTo() != null) {
            Optional xmlObject = messageStorage.get(response.getInResponseTo());
            if (xmlObject.isEmpty()) {
                throw new SAMLInResponseToMismatchException("InResponseToField of the Response doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (xmlObject.get() instanceof AuthnRequest) {
                request = (AuthnRequest)xmlObject.get();
            } else {
                throw new SAMLInResponseToMismatchException("Sent request was of different type than the expected AuthnRequest " + response.getInResponseTo());
            }
        }
        Endpoint endpoint = Objects.requireNonNull(context.getSAMLEndpointContext().getEndpoint());
        ArrayList<String> expected = new ArrayList<String>();
        if (endpoint.getLocation() != null) {
            expected.add(endpoint.getLocation());
        }
        if (endpoint.getResponseLocation() != null) {
            expected.add(endpoint.getResponseLocation());
        }
        boolean isDestinationMandatory = context.getSAML2Configuration().isResponseDestinationAttributeMandatory();
        this.verifyEndpoint(expected, response.getDestination(), isDestinationMandatory);
        if (request != null) {
            this.verifyRequest(request, context);
        }
        this.validateIssuerIfItExists(response.getIssuer(), context);
    }

    protected void verifyRequest(AuthnRequest request, SAML2MessageContext context) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)context.getSAMLEndpointContext().getEndpoint();
        if (request.getAssertionConsumerServiceIndex() != null) {
            if (!request.getAssertionConsumerServiceIndex().equals(assertionConsumerService.getIndex())) {
                this.logger.warn("Response was received at a different endpoint index than was requested");
            }
        } else {
            String responseLocation;
            String requestedResponseURL = request.getAssertionConsumerServiceURL();
            String requestedBinding = request.getProtocolBinding();
            if (requestedResponseURL != null && !requestedResponseURL.equals(responseLocation = assertionConsumerService.getResponseLocation() != null ? assertionConsumerService.getResponseLocation() : assertionConsumerService.getLocation())) {
                this.logger.warn("Response was received at a different endpoint URL {} than was requested {}", (Object)responseLocation, (Object)requestedResponseURL);
            }
            if (requestedBinding != null && !requestedBinding.equals(context.getSAMLBindingContext().getBindingUri())) {
                this.logger.warn("Response was received using a different binding {} than was requested {}", (Object)context.getSAMLBindingContext().getBindingUri(), (Object)requestedBinding);
            }
        }
    }

    protected void validateSamlSSOResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        ArrayList<SAMLException> errors = new ArrayList<SAMLException>();
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getAuthnStatements().isEmpty()) continue;
            try {
                this.validateAssertion(assertion, context, engine, decrypter);
            }
            catch (SAMLException e) {
                this.logger.error("Current assertion validation failed, continue with the next one", (Throwable)((Object)e));
                errors.add(e);
                continue;
            }
            context.setSubjectAssertion(assertion);
            break;
        }
        if (!errors.isEmpty()) {
            throw (SAMLException)((Object)errors.get(0));
        }
        if (context.getSubjectAssertion() == null) {
            throw new SAMAssertionSubjectException("No valid subject assertion found in response");
        }
        List<SubjectConfirmation> subjectConfirmations = context.getSubjectConfirmations();
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        if (subjectConfirmations == null || subjectConfirmations.isEmpty()) {
            if (configContext.getNameIdAttribute() != null) {
                this.logger.debug("NameID will be determined from attribute {}", (Object)configContext.getNameIdAttribute());
            } else {
                NameID nameIdentifier = (NameID)context.getSAMLSubjectNameIdentifierContext().getSubjectNameIdentifier();
                if (!(nameIdentifier != null && nameIdentifier.getValue() != null || context.getBaseID() != null || subjectConfirmations != null && !subjectConfirmations.isEmpty())) {
                    throw new SAMLException("Subject NameID, BaseID and EncryptedID cannot be all null at the same time without Subject Confirmations.");
                }
            }
        }
    }

    protected void decryptEncryptedAssertions(Response response, Decrypter decrypter) {
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            try {
                Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
                response.getAssertions().add(decryptedAssertion);
            }
            catch (DecryptionException e) {
                this.logger.error("Decryption of assertion failed, continue with the next one", (Throwable)e);
            }
        }
    }

    protected void validateAssertion(Assertion assertion, SAML2MessageContext context, SignatureTrustEngine engine, Decrypter decrypter) {
        if (!assertion.getVersion().equals(SAMLVersion.VERSION_20)) {
            throw new SAMLException("Invalid SAML assertion version");
        }
        this.validateIssueInstant(assertion.getIssueInstant());
        this.validateIssuer(assertion.getIssuer(), context);
        if (assertion.getSubject() == null) {
            throw new SAMAssertionSubjectException("Assertion subject cannot be null");
        }
        this.validateSubject(assertion.getSubject(), context, decrypter);
        this.validateAssertionConditions(assertion.getConditions(), context);
        this.validateAuthenticationStatements(assertion.getAuthnStatements(), context);
        this.validateAssertionSignature(assertion.getSignature(), context, engine);
    }

    protected void validateSubject(Subject subject, SAML2MessageContext context, Decrypter decrypter) {
        boolean samlIDFound = false;
        NameID nameIdFromSubject = subject.getNameID();
        BaseID baseIdFromSubject = subject.getBaseID();
        EncryptedID encryptedIdFromSubject = subject.getEncryptedID();
        NameID decryptedNameIdFromSubject = this.decryptEncryptedId(encryptedIdFromSubject, decrypter);
        if (decryptedNameIdFromSubject != null) {
            nameIdFromSubject = decryptedNameIdFromSubject;
        }
        if (nameIdFromSubject != null || baseIdFromSubject != null) {
            context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIdFromSubject);
            context.setBaseID(baseIdFromSubject);
            samlIDFound = true;
        }
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod()) || !this.isValidBearerSubjectConfirmationData(confirmation.getSubjectConfirmationData(), context)) continue;
            this.validateAssertionReplay((Assertion)subject.getParent(), confirmation.getSubjectConfirmationData());
            NameID nameIDFromConfirmation = confirmation.getNameID();
            BaseID baseIDFromConfirmation = confirmation.getBaseID();
            EncryptedID encryptedIDFromConfirmation = confirmation.getEncryptedID();
            NameID decryptedNameIdFromConfirmation = this.decryptEncryptedId(encryptedIDFromConfirmation, decrypter);
            if (decryptedNameIdFromConfirmation != null) {
                nameIDFromConfirmation = decryptedNameIdFromConfirmation;
            }
            if (!(samlIDFound || nameIDFromConfirmation == null && baseIDFromConfirmation == null)) {
                context.getSAMLSubjectNameIdentifierContext().setSubjectNameIdentifier((SAMLObject)nameIDFromConfirmation);
                context.setBaseID(baseIDFromConfirmation);
                context.getSubjectConfirmations().add(confirmation);
                samlIDFound = true;
            }
            if (!samlIDFound) {
                this.logger.warn("Could not find any Subject NameID/BaseID/EncryptedID, neither directly in the Subject nor in any Subject Confirmation.");
            }
            return;
        }
        throw new SAMLSubjectConfirmationException("Subject confirmation validation failed");
    }

    protected boolean isValidBearerSubjectConfirmationData(SubjectConfirmationData data, SAML2MessageContext context) {
        if (data == null) {
            this.logger.debug("SubjectConfirmationData cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotBefore() != null) {
            this.logger.debug("SubjectConfirmationData notBefore must be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter() == null) {
            this.logger.debug("SubjectConfirmationData notOnOrAfter cannot be null for Bearer confirmation");
            return false;
        }
        Instant now = ZonedDateTime.now(ZoneOffset.UTC).toInstant();
        boolean expired = data.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBefore(now);
        if (expired) {
            this.logger.debug("SubjectConfirmationData notOnOrAfter is too old");
            return false;
        }
        try {
            URI appEndpointUri;
            if (data.getRecipient() == null) {
                this.logger.debug("SubjectConfirmationData recipient cannot be null for Bearer confirmation");
                return false;
            }
            Endpoint endpoint = context.getSAMLEndpointContext().getEndpoint();
            if (endpoint == null) {
                this.logger.warn("No endpoint was found in the SAML endpoint context");
                return false;
            }
            URI recipientUri = new URI(data.getRecipient());
            if (!SAML2Utils.urisEqualAfterPortNormalization(recipientUri, appEndpointUri = new URI(endpoint.getLocation()))) {
                this.logger.debug("SubjectConfirmationData recipient {} does not match SP assertion consumer URL, found. SP ACS URL from context: {}", (Object)recipientUri, (Object)appEndpointUri);
                return false;
            }
        }
        catch (URISyntaxException use) {
            this.logger.error("Unable to check SubjectConfirmationData recipient, a URI has invalid syntax.", (Throwable)use);
            return false;
        }
        return true;
    }

    protected void validateAssertionReplay(Assertion assertion, SubjectConfirmationData data) {
        if (assertion.getID() == null) {
            throw new SAMLReplayException("The assertion does not have an ID");
        }
        if (this.replayCache == null) {
            this.logger.warn("No replay cache specified, skipping replay verification");
            return;
        }
        Instant expires = Instant.ofEpochMilli(data.getNotOnOrAfter().toEpochMilli() + this.acceptedSkew * 1000L);
        if (!this.replayCache.get().check(this.getClass().getName(), assertion.getID(), expires)) {
            throw new SAMLReplayException("Rejecting replayed assertion ID '" + assertion.getID() + "'");
        }
    }

    protected void validateAssertionConditions(Conditions conditions, SAML2MessageContext context) {
        boolean expired;
        if (conditions == null) {
            return;
        }
        Instant now = ZonedDateTime.now(ZoneOffset.UTC).toInstant();
        if (conditions.getNotBefore() != null && (expired = conditions.getNotBefore().minusSeconds(this.acceptedSkew).isAfter(now))) {
            throw new SAMLAssertionConditionException("Assertion condition notBefore is not valid");
        }
        if (conditions.getNotOnOrAfter() != null && (expired = conditions.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBefore(now))) {
            throw new SAMLAssertionConditionException("Assertion condition notOnOrAfter is not valid");
        }
        String entityId = context.getSAMLSelfEntityContext().getEntityId();
        this.validateAudienceRestrictions(conditions.getAudienceRestrictions(), entityId);
    }

    protected void validateAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            throw new SAMLAssertionAudienceException("Audience restrictions cannot be null or empty");
        }
        HashSet<String> audienceUris = new HashSet<String>();
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() == null) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                audienceUris.add(audience.getURI());
            }
        }
        if (!audienceUris.contains(spEntityId)) {
            throw new SAMLAssertionAudienceException("Assertion audience " + audienceUris + " does not match SP configuration " + spEntityId);
        }
    }

    protected void validateAuthenticationStatements(List<AuthnStatement> authnStatements, SAML2MessageContext context) {
        ArrayList<String> authnClassRefs = new ArrayList<String>();
        Instant now = ZonedDateTime.now(ZoneOffset.UTC).toInstant();
        for (AuthnStatement statement : authnStatements) {
            boolean expired;
            if (!this.isAuthnInstantValid(context, statement.getAuthnInstant())) {
                throw new SAMLAuthnInstantException("Authentication issue instant is too old or in the future");
            }
            if (statement.getSessionNotOnOrAfter() != null && (expired = statement.getSessionNotOnOrAfter().isBefore(now))) {
                throw new SAMLAuthnSessionCriteriaException("Authentication session between IDP and subject has ended");
            }
            authnClassRefs.add(statement.getAuthnContext().getAuthnContextClassRef().getURI());
        }
        this.validateAuthnContextClassRefs(context, authnClassRefs);
    }

    protected void validateAuthnContextClassRefs(SAML2MessageContext context, List<String> providedAuthnContextClassRefs) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        if (!configContext.getAuthnContextClassRefs().isEmpty()) {
            this.logger.debug("Required authentication context class refs are {}", configContext.getAuthnContextClassRefs());
            this.logger.debug("Found authentication context class refs are {}", providedAuthnContextClassRefs);
            Collection results = CollectionUtils.intersection(configContext.getAuthnContextClassRefs(), providedAuthnContextClassRefs);
            if (results.size() != configContext.getAuthnContextClassRefs().size()) {
                throw new SAMLAuthnContextClassRefException("Requested authentication context class refs do not match  those in authentication statements from IDP.");
            }
        }
    }

    protected void validateAssertionSignature(Signature signature, SAML2MessageContext context, SignatureTrustEngine engine) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        if (signature != null) {
            String entityId = peerContext.getEntityId();
            this.validateSignature(signature, entityId, engine);
        } else {
            if (this.wantsAssertionsSigned(context).booleanValue()) {
                throw new SAMLSignatureRequiredException("Assertion must be explicitly signed");
            }
            if (!peerContext.isAuthenticated() && !configContext.getSAML2Configuration().isAllSignatureValidationDisabled()) {
                throw new SAMLSignatureRequiredException("Unauthenticated response contains an unsigned assertion");
            }
        }
    }

    @VisibleForTesting
    Boolean wantsAssertionsSigned(SAML2MessageContext context) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        if (spDescriptor == null) {
            return configContext.isWantsAssertionsSigned();
        }
        return spDescriptor.getWantAssertionsSigned();
    }

    private boolean isAuthnInstantValid(SAML2MessageContext context, Instant authnInstant) {
        SAML2ConfigurationContext configContext = context.getConfigurationContext();
        return this.isDateValid(authnInstant, configContext.getMaximumAuthenticationLifetime());
    }
}

