/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredentialProvider
implements CredentialProvider {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreCredentialProvider.class);
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private final CredentialResolver credentialResolver;
    private final String privateKeyAlias;

    public KeyStoreCredentialProvider(SAML2Configuration configuration) {
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)configuration.getPrivateKeyPassword());
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)configuration.getPrivateKeyPassword());
        try (InputStream inputStream = configuration.getKeystoreGenerator().retrieve();){
            String keyStoreType = configuration.getKeyStoreType() == null ? DEFAULT_KEYSTORE_TYPE : configuration.getKeyStoreType();
            KeyStore keyStore = KeyStoreCredentialProvider.loadKeyStore(inputStream, configuration.getKeystorePassword(), keyStoreType);
            this.privateKeyAlias = KeyStoreCredentialProvider.getPrivateKeyAlias(keyStore, configuration.getKeyStoreAlias());
            HashMap<String, String> passwords = new HashMap<String, String>();
            passwords.put(this.privateKeyAlias, configuration.getPrivateKeyPassword());
            this.credentialResolver = new KeyStoreCredentialResolver(keyStore, passwords);
        }
        catch (Exception e) {
            throw new SAMLException("Error loading keystore", e);
        }
    }

    private static KeyStore loadKeyStore(InputStream inputStream, String storePasswd, String keyStoreType) {
        try {
            logger.debug("Loading keystore with type {}", (Object)keyStoreType);
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(inputStream, storePasswd == null ? null : storePasswd.toCharArray());
            logger.debug("Loaded keystore with type {} with size {}", (Object)keyStoreType, (Object)ks.size());
            return ks;
        }
        catch (Exception e) {
            throw new SAMLException("Error loading keystore", e);
        }
    }

    protected static String getPrivateKeyAlias(KeyStore keyStore, String keyStoreAlias) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String currentAlias = aliases.nextElement();
                if (!(keyStoreAlias != null ? currentAlias.equalsIgnoreCase(keyStoreAlias) : keyStore.entryInstanceOf(currentAlias, KeyStore.PrivateKeyEntry.class))) continue;
                return currentAlias;
            }
            throw new SAMLException("Keystore has no private keys to match the requested key alias " + keyStoreAlias);
        }
        catch (KeyStoreException e) {
            throw new SAMLException("Unable to get aliases from keyStore", e);
        }
    }

    @Override
    public KeyInfo getKeyInfo() {
        Credential serverCredential = this.getCredential();
        return this.generateKeyInfoForCredential(serverCredential);
    }

    @Override
    public final CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        return DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
    }

    @Override
    public final KeyInfoGenerator getKeyInfoGenerator() {
        NamedKeyInfoGeneratorManager mgmr = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        Credential credential = this.getCredential();
        return mgmr.getDefaultManager().getFactory(credential).newInstance();
    }

    @Override
    public final Credential getCredential() {
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIdCriterion criteria = new EntityIdCriterion(this.privateKeyAlias);
            cs.add((Object)criteria);
            return (Credential)this.credentialResolver.resolveSingle((Object)cs);
        }
        catch (ResolverException e) {
            throw new SAMLException("Can't obtain SP private key", e);
        }
    }

    protected final KeyInfo generateKeyInfoForCredential(Credential credential) {
        try {
            return this.getKeyInfoGenerator().generate(credential);
        }
        catch (SecurityException e) {
            throw new SAMLException("Unable to generate keyInfo from given credential", e);
        }
    }
}

