/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import com.google.common.collect.HashMultimap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.AbstractMessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.context.SAML2MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPac4jDecoder
extends AbstractMessageDecoder {
    static final String[] SAML_PARAMETERS = new String[]{"SAMLRequest", "SAMLResponse", "logoutRequest"};
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ParserPool parserPool;
    protected final WebContext context;

    public AbstractPac4jDecoder(WebContext context) {
        CommonHelper.assertNotNull((String)"context", (Object)context);
        this.context = context;
    }

    protected byte[] getBase64DecodedMessage() throws MessageDecodingException {
        String parameter;
        Optional<String> encodedMessage = Optional.empty();
        String[] stringArray = SAML_PARAMETERS;
        int n = stringArray.length;
        for (int i = 0; i < n && !(encodedMessage = this.context.getRequestParameter(parameter = stringArray[i])).isPresent(); ++i) {
        }
        if (!encodedMessage.isPresent() && (encodedMessage = Optional.ofNullable(this.context.getRequestContent())).isPresent()) {
            List a = URLEncodedUtils.parse((String)((String)encodedMessage.get()), (Charset)StandardCharsets.UTF_8);
            HashMultimap paramMap = HashMultimap.create();
            for (NameValuePair p : a) {
                paramMap.put((Object)p.getName(), (Object)p.getValue());
            }
            for (String parameter2 : SAML_PARAMETERS) {
                Collection newEncodedMessageCollection = paramMap.get((Object)parameter2);
                if (newEncodedMessageCollection == null || newEncodedMessageCollection.isEmpty()) continue;
                encodedMessage = Optional.of((String)newEncodedMessageCollection.iterator().next());
                break;
            }
        }
        if (!encodedMessage.isPresent()) {
            throw new MessageDecodingException("Request did not contain either a SAMLRequest parameter, a SAMLResponse parameter, a logoutRequest parameter or a body content");
        }
        if (((String)encodedMessage.get()).contains("<")) {
            this.logger.trace("Raw SAML message:\n{}", (Object)encodedMessage);
            return ((String)encodedMessage.get()).getBytes(StandardCharsets.UTF_8);
        }
        try {
            byte[] decodedBytes = Base64Support.decode((String)((String)encodedMessage.get()));
            this.logger.trace("Decoded SAML message:\n{}", (Object)new String(decodedBytes, StandardCharsets.UTF_8));
            return decodedBytes;
        }
        catch (Exception e) {
            throw new MessageDecodingException(e);
        }
    }

    protected void doDestroy() {
        this.parserPool = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logger.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    protected void populateBindingContext(SAML2MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getMessageContext().getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI(messageContext));
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned((MessageContext)messageContext.getMessageContext()));
    }

    public abstract String getBindingURI(SAML2MessageContext var1);

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.getParserPool(), (InputStream)messageStream);
            return message;
        }
        catch (XMLParserException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            throw new MessageDecodingException("Error unmarshalling message from input stream", (Exception)((Object)e));
        }
    }

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(ParserPool pool) {
        Constraint.isNotNull((Object)pool, (String)"ParserPool cannot be null");
        this.parserPool = pool;
    }
}

