/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2MessageSender;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jHTTPPostSimpleSignEncoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.SAML2Utils;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2MessageSender<T extends SAMLObject>
implements SAML2MessageSender<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSAML2MessageSender.class);
    protected final SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected final String destinationBindingType;
    protected final boolean signErrorResponses;
    protected final boolean isRequestSigned;

    @Override
    public void sendMessage(SAML2MessageContext context, T request, Object relayState) {
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        IDPSSODescriptor idpssoDescriptor = context.getIDPSSODescriptor();
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        MessageEncoder encoder = this.getMessageEncoder(spDescriptor, idpssoDescriptor, context);
        SAML2MessageContext outboundContext = new SAML2MessageContext(context.getCallContext());
        outboundContext.setMessageContext(context.getMessageContext());
        outboundContext.getProfileRequestContext().setProfileId(outboundContext.getProfileRequestContext().getProfileId());
        outboundContext.getProfileRequestContext().setInboundMessageContext(context.getProfileRequestContext().getInboundMessageContext());
        outboundContext.getProfileRequestContext().setOutboundMessageContext(context.getProfileRequestContext().getOutboundMessageContext());
        outboundContext.getMessageContext().setMessage(request);
        outboundContext.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        outboundContext.getSAMLPeerEndpointContext().setEndpoint(this.getEndpoint(outboundContext));
        outboundContext.getSAMLPeerEntityContext().setRole(outboundContext.getSAMLPeerEntityContext().getRole());
        outboundContext.getSAMLPeerEntityContext().setEntityId(outboundContext.getSAMLPeerEntityContext().getEntityId());
        outboundContext.getSAMLProtocolContext().setProtocol(outboundContext.getSAMLProtocolContext().getProtocol());
        outboundContext.getSecurityParametersContext().setSignatureSigningParameters(this.signatureSigningParametersProvider.build((SSODescriptor)spDescriptor));
        if (relayState != null) {
            outboundContext.getSAMLBindingContext().setRelayState(relayState.toString());
        }
        try {
            MessageContext messageContext = outboundContext.getMessageContext();
            this.invokeOutboundMessageHandlers(spDescriptor, idpssoDescriptor, messageContext);
            encoder.setMessageContext(messageContext);
            encoder.initialize();
            encoder.prepareContext();
            encoder.encode();
            this.storeMessage(context, request);
            SAML2Utils.logProtocolMessage(request);
        }
        catch (MessageEncodingException e) {
            throw new SAMLException("Error encoding saml message", e);
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing saml encoder", e);
        }
    }

    protected void storeMessage(SAML2MessageContext context, T request) {
        SAMLMessageStore messageStorage = context.getSamlMessageStore();
        if (messageStorage != null) {
            if (request instanceof RequestAbstractType) {
                RequestAbstractType requestAbstractType = (RequestAbstractType)request;
                messageStorage.set(requestAbstractType.getID(), request);
            } else if (request instanceof StatusResponseType) {
                StatusResponseType statusResponseType = (StatusResponseType)request;
                messageStorage.set(statusResponseType.getID(), request);
            }
        }
    }

    protected abstract Endpoint getEndpoint(SAML2MessageContext var1);

    protected void invokeOutboundMessageHandlers(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, MessageContext messageContext) {
        try {
            EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
            handlerEnd.initialize();
            handlerEnd.invoke(messageContext);
            SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
            handlerDest.initialize();
            handlerDest.invoke(messageContext);
            if (!this.destinationBindingType.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && this.mustSignRequest(spDescriptor, idpssoDescriptor)) {
                LOGGER.debug("Signing SAML2 outbound context...");
                SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
                handler.setSignErrorResponses(this.signErrorResponses);
                handler.initialize();
                handler.invoke(messageContext);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected boolean mustSignRequest(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor) {
        return this.isRequestSigned;
    }

    private MessageEncoder getMessageEncoder(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext ctx) {
        Pac4jSAMLResponse adapter = ctx.getProfileRequestContextOutboundMessageTransportResponse();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostEncoder encoder = new Pac4jHTTPPostEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostSimpleSignEncoder encoder = new Pac4jHTTPPostSimpleSignEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            return new Pac4jHTTPRedirectDeflateEncoder(adapter, this.mustSignRequest(spDescriptor, idpssoDescriptor));
        }
        throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractSAML2MessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean signErrorResponses, boolean isRequestSigned) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
        this.destinationBindingType = destinationBindingType;
        this.signErrorResponses = signErrorResponses;
        this.isRequestSigned = isRequestSigned;
    }
}

