/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.extractor;

import java.util.Optional;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.logout.LogoutType;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.sso.artifact.SAML2ArtifactBindingDecoder;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.transport.AbstractPac4jDecoder;
import org.pac4j.saml.transport.Pac4jHTTPPostDecoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateDecoder;
import org.pac4j.saml.util.Configuration;

public class SAML2CredentialsExtractor
implements CredentialsExtractor {
    private final SAMLContextProvider contextProvider;
    private final SAML2Client saml2Client;
    private final SAML2Configuration saml2Configuration;
    private final SAML2MetadataResolver idpMetadataResolver;
    private final SAML2MetadataResolver spMetadataResolver;
    private final SOAPPipelineProvider soapPipelineProvider;

    public SAML2CredentialsExtractor(SAML2Client client, SAML2MetadataResolver idpMetadataResolver, SAML2MetadataResolver spMetadataResolver, SOAPPipelineProvider soapPipelineProvider) {
        this.saml2Client = client;
        this.saml2Configuration = client.getConfiguration();
        this.contextProvider = client.getContextProvider();
        this.idpMetadataResolver = idpMetadataResolver;
        this.spMetadataResolver = spMetadataResolver;
        this.soapPipelineProvider = soapPipelineProvider;
    }

    public Optional<Credentials> extract(CallContext ctx) {
        SAML2MessageContext samlContext = this.contextProvider.buildContext(ctx, this.saml2Client);
        samlContext.setSaml2Configuration(this.saml2Configuration);
        SAMLPeerEntityContext peerContext = samlContext.getSAMLPeerEntityContext();
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        samlContext.getSAMLSelfProtocolContext().setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        AbstractPac4jDecoder decoder = this.getDecoder(ctx);
        SAML2MessageContext decodedCtx = this.prepareDecodedContext(samlContext, decoder);
        Object message = decodedCtx.getMessageContext().getMessage();
        if (message instanceof Response) {
            Response response = (Response)message;
            decodedCtx.getSAMLEndpointContext().setEndpoint((Endpoint)decodedCtx.getSPAssertionConsumerService((StatusResponseType)response));
            decodedCtx.getProfileRequestContext().setProfileId("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser");
            return Optional.of(new SAML2Credentials(decodedCtx));
        }
        decodedCtx.getProfileRequestContext().setProfileId("urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout");
        String binding = decodedCtx.getSAMLBindingContext().getBindingUri();
        LogoutType type = CommonHelper.areEquals((String)binding, (String)"urn:oasis:names:tc:SAML:2.0:bindings:SOAP") ? LogoutType.BACK : LogoutType.FRONT;
        return Optional.of(new SAML2Credentials(type, decodedCtx));
    }

    protected AbstractPac4jDecoder getDecoder(CallContext callContext) {
        AbstractPac4jDecoder decoder;
        Optional artifact = callContext.webContext().getRequestParameter("SAMLart");
        if (artifact.isPresent()) {
            decoder = new SAML2ArtifactBindingDecoder(callContext, this.idpMetadataResolver, this.spMetadataResolver, this.soapPipelineProvider);
            try {
                decoder.setParserPool(Configuration.getParserPool());
                decoder.initialize();
                decoder.decode();
            }
            catch (Exception e) {
                throw new SAMLException("Error decoding Artifact SAML message", e);
            }
        } else if (WebContextHelper.isPost((WebContext)callContext.webContext())) {
            decoder = new Pac4jHTTPPostDecoder(callContext);
            try {
                decoder.setParserPool(Configuration.getParserPool());
                decoder.initialize();
                decoder.decode();
            }
            catch (Exception e) {
                throw new SAMLException("Error decoding POST SAML message", e);
            }
        } else if (WebContextHelper.isGet((WebContext)callContext.webContext())) {
            decoder = new Pac4jHTTPRedirectDeflateDecoder(callContext);
            try {
                decoder.setParserPool(Configuration.getParserPool());
                decoder.initialize();
                decoder.decode();
            }
            catch (Exception e) {
                throw new SAMLException("Error decoding HTTP-Redirect SAML message", e);
            }
        } else {
            throw new SAMLException("Unsupported binding");
        }
        return decoder;
    }

    protected SAML2MessageContext prepareDecodedContext(SAML2MessageContext context, AbstractPac4jDecoder decoder) {
        SAML2MessageContext decodedCtx = new SAML2MessageContext(decoder.getCallContext());
        decodedCtx.setSaml2Configuration(this.saml2Configuration);
        decodedCtx.setMessageContext(decoder.getMessageContext());
        SAMLObject message = (SAMLObject)decoder.getMessageContext().getMessage();
        if (message == null) {
            throw new SAMLException("Response from the context cannot be null");
        }
        decodedCtx.getMessageContext().setMessage((Object)message);
        context.getMessageContext().setMessage((Object)message);
        decodedCtx.setSamlMessageStore(context.getSamlMessageStore());
        SAMLBindingContext bindingContext = this.prepareBindingContext(context, decoder, decodedCtx);
        EntityDescriptor metadata = context.getSAMLPeerMetadataContext().getEntityDescriptor();
        if (metadata == null) {
            throw new SAMLException("IDP Metadata cannot be null");
        }
        this.preparePeerEntityContext(decoder, decodedCtx, bindingContext, metadata);
        this.prepareSelfEntityContext(context, decodedCtx);
        decodedCtx.getSAMLSelfMetadataContext().setRoleDescriptor((RoleDescriptor)context.getSPSSODescriptor());
        return decodedCtx;
    }

    protected void prepareSelfEntityContext(SAML2MessageContext context, SAML2MessageContext decodedCtx) {
        decodedCtx.getSAMLSelfEntityContext().setEntityId(context.getSAMLSelfEntityContext().getEntityId());
        decodedCtx.getSAMLSelfEndpointContext().setEndpoint(context.getSAMLSelfEndpointContext().getEndpoint());
        decodedCtx.getSAMLSelfEntityContext().setRole(context.getSAMLSelfEntityContext().getRole());
    }

    protected void preparePeerEntityContext(AbstractPac4jDecoder decoder, SAML2MessageContext decodedCtx, SAMLBindingContext bindingContext, EntityDescriptor metadata) {
        SAMLPeerEntityContext decodedPeerContext = (SAMLPeerEntityContext)decoder.getMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        CommonHelper.assertNotNull((String)"SAMLPeerEntityContext", (Object)bindingContext);
        decodedCtx.getSAMLPeerEntityContext().setEntityId(metadata.getEntityID());
        decodedCtx.getSAMLPeerEntityContext().setAuthenticated(decodedPeerContext != null && decodedPeerContext.isAuthenticated());
    }

    protected SAMLBindingContext prepareBindingContext(SAML2MessageContext context, AbstractPac4jDecoder decoder, SAML2MessageContext decodedCtx) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)decoder.getMessageContext().getSubcontext(SAMLBindingContext.class);
        CommonHelper.assertNotNull((String)"SAMLBindingContext", (Object)bindingContext);
        decodedCtx.getSAMLBindingContext().setBindingDescriptor(bindingContext.getBindingDescriptor());
        decodedCtx.getSAMLBindingContext().setBindingUri(bindingContext.getBindingUri());
        decodedCtx.getSAMLBindingContext().setHasBindingSignature(bindingContext.hasBindingSignature());
        decodedCtx.getSAMLBindingContext().setIntendedDestinationEndpointURIRequired(bindingContext.isIntendedDestinationEndpointURIRequired());
        String relayState = bindingContext.getRelayState();
        decodedCtx.getSAMLBindingContext().setRelayState(relayState);
        context.getSAMLBindingContext().setRelayState(relayState);
        return bindingContext;
    }
}

