/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.shibboleth.shared.net.URIComparator;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.logout.LogoutType;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.credentials.SAML2AuthenticationCredentials;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.impl.AbstractSAML2ResponseValidator;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.util.Configuration;

public class SAML2LogoutValidator
extends AbstractSAML2ResponseValidator {
    private boolean isPartialLogoutTreatedAsSuccess = false;
    private String expectedDestination;

    public SAML2LogoutValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, SessionLogoutHandler logoutHandler, ReplayCacheProvider replayCache, URIComparator uriComparator) {
        super(engine, decrypter, logoutHandler, replayCache, uriComparator);
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessageContext().getMessage();
        if (message instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutRequest(logoutRequest, context, engine);
            return new SAML2Credentials(LogoutType.UNDEFINED, context);
        }
        if (message instanceof LogoutResponse) {
            LogoutResponse logoutResponse = (LogoutResponse)message;
            SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
            this.validateLogoutResponse(logoutResponse, context, engine);
            return new SAML2Credentials(LogoutType.UNDEFINED, context);
        }
        throw new SAMLException("SAML message must be a LogoutRequest or LogoutResponse type");
    }

    protected void validateLogoutRequest(LogoutRequest logoutRequest, SAML2MessageContext context, SignatureTrustEngine engine) {
        String sloKey;
        SessionIndex sessionIndexObject;
        this.logger.trace("Validating logout request:\n{}", (Object)Configuration.serializeSamlObject((XMLObject)logoutRequest));
        this.validateSignatureIfItExists(logoutRequest.getSignature(), context, engine);
        this.validateIssuerIfItExists(logoutRequest.getIssuer(), context);
        NameID nameId = logoutRequest.getNameID();
        EncryptedID encryptedID = logoutRequest.getEncryptedID();
        if (encryptedID != null) {
            nameId = this.decryptEncryptedId(encryptedID, this.decrypter);
        }
        SAML2AuthenticationCredentials.SAMLNameID samlNameId = SAML2AuthenticationCredentials.SAMLNameID.from(nameId);
        String sessionIndex = null;
        List sessionIndexes = logoutRequest.getSessionIndexes();
        if (sessionIndexes != null && !sessionIndexes.isEmpty() && (sessionIndexObject = (SessionIndex)sessionIndexes.get(0)) != null) {
            sessionIndex = sessionIndexObject.getValue();
        }
        if ((sloKey = this.computeSloKey(sessionIndex, samlNameId)) != null) {
            this.logoutHandler.destroySession(context.getCallContext(), sloKey);
        }
    }

    protected void validateLogoutResponse(LogoutResponse logoutResponse, SAML2MessageContext context, SignatureTrustEngine engine) {
        this.logger.trace("Validating logout response:\n{}", (Object)Configuration.serializeSamlObject((XMLObject)logoutResponse));
        this.validateSuccess(logoutResponse.getStatus());
        this.validateSignatureIfItExists(logoutResponse.getSignature(), context, engine);
        this.validateIssueInstant(logoutResponse.getIssueInstant());
        this.validateIssuerIfItExists(logoutResponse.getIssuer(), context);
        this.validateDestinationEndpoint(logoutResponse, context);
    }

    protected void validateDestinationEndpoint(LogoutResponse logoutResponse, SAML2MessageContext context) {
        ArrayList<String> expected = new ArrayList<String>();
        if (CommonHelper.isBlank((String)this.expectedDestination)) {
            SingleLogoutService endpoint = Objects.requireNonNull((SingleLogoutService)context.getSPSSODescriptor().getSingleLogoutServices().get(0));
            if (endpoint.getLocation() != null) {
                expected.add(endpoint.getLocation());
            }
            if (endpoint.getResponseLocation() != null) {
                expected.add(endpoint.getResponseLocation());
            }
        } else {
            expected.add(this.expectedDestination);
        }
        boolean isDestinationMandatory = context.getSaml2Configuration().isResponseDestinationAttributeMandatory();
        this.verifyEndpoint(expected, logoutResponse.getDestination(), isDestinationMandatory);
    }

    @Override
    protected void validateSuccess(Status status) {
        if (this.isPartialLogoutTreatedAsSuccess && status != null && status.getStatusCode() != null) {
            if ("urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(status.getStatusCode().getValue())) {
                this.logger.debug("Response status code is {} and partial logouts are configured to be treated as success => validation successful!", (Object)"urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
                return;
            }
            this.logger.debug("Response status code: {}", (Object)status.getStatusCode().getValue());
            if ("urn:oasis:names:tc:SAML:2.0:status:Responder".equals(status.getStatusCode().getValue())) {
                if (status.getStatusCode().getOrderedChildren().stream().filter(StatusCode.class::isInstance).map(StatusCode.class::cast).anyMatch(code -> "urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(code.getValue()))) {
                    this.logger.debug("Response sub-status code is {} and partial logouts are configured to be treated as success => validation successful!", (Object)"urn:oasis:names:tc:SAML:2.0:status:PartialLogout");
                    return;
                }
            }
        }
        super.validateSuccess(status);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPartialLogoutTreatedAsSuccess() {
        return this.isPartialLogoutTreatedAsSuccess;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getExpectedDestination() {
        return this.expectedDestination;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPartialLogoutTreatedAsSuccess(boolean isPartialLogoutTreatedAsSuccess) {
        this.isPartialLogoutTreatedAsSuccess = isPartialLogoutTreatedAsSuccess;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExpectedDestination(String expectedDestination) {
        this.expectedDestination = expectedDestination;
    }
}

