/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;

public class SAML2HttpUrlKeystoreGenerator
extends BaseSAML2KeystoreGenerator {
    public SAML2HttpUrlKeystoreGenerator(SAML2Configuration configuration) {
        super(configuration);
    }

    @Override
    public InputStream retrieve() throws Exception {
        this.validate();
        String url = this.saml2Configuration.getKeystoreResource().getURL().toExternalForm();
        this.logger.debug("Loading keystore from {}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Accept", (Object)ContentType.TEXT_PLAIN.getMimeType());
        httpGet.addHeader("Content-Type", (Object)ContentType.TEXT_PLAIN.getMimeType());
        return (InputStream)this.saml2Configuration.getHttpClient().execute((ClassicHttpRequest)httpGet, response -> {
            try {
                int code;
                if (response != null && (code = response.getCode()) == 200) {
                    this.logger.info("Successfully submitted/created keystore to {}", (Object)url);
                    String results = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(results));
                    return byteArrayInputStream;
                }
                throw new SAMLException("Unable to retrieve keystore from " + url);
            }
            finally {
                if (response != null && response instanceof CloseableHttpResponse) {
                    ((CloseableHttpResponse)response).close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
        this.validate();
        HttpResponse response = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            char[] password = this.saml2Configuration.getKeystorePassword().toCharArray();
            ks.store(out, password);
            out.flush();
            String content = Base64.getEncoder().encodeToString(out.toByteArray());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Encoded keystore as base-64: {}", (Object)content);
            }
            String url = this.saml2Configuration.getKeystoreResource().getURL().toExternalForm();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Accept", (Object)ContentType.TEXT_PLAIN.getMimeType());
            httpPost.addHeader("Content-Type", (Object)ContentType.TEXT_PLAIN.getMimeType());
            httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.TEXT_PLAIN));
            this.logger.debug("Submitting keystore to {}", (Object)url);
            response = this.saml2Configuration.getHttpClient().execute((ClassicHttpRequest)httpPost);
            if (response != null) {
                int code = response.getCode();
                if (code == 501) {
                    this.logger.info("Storing keystore is not supported/implemented by {}", (Object)url);
                } else if (code == 200 || code == 201) {
                    this.logger.info("Successfully submitted/created keystore to {}", (Object)url);
                } else if (code == 304) {
                    this.logger.info("Keystore was not modified/updated: {}", (Object)url);
                } else {
                    this.logger.error("Unable to store keystore successfully via {}", (Object)url);
                }
            }
        }
        finally {
            if (response != null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
    }

    private void validate() {
        CommonHelper.assertNotNull((String)"keystoreResource", (Object)this.saml2Configuration.getKeystoreResource());
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.saml2Configuration.getPrivateKeyPassword());
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.saml2Configuration.getPrivateKeyPassword());
    }
}

