/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.authenticator.SAML2Authenticator;
import org.pac4j.saml.credentials.extractor.SAML2CredentialsExtractor;
import org.pac4j.saml.crypto.DefaultSignatureSigningParametersProvider;
import org.pac4j.saml.crypto.ExplicitSignatureTrustEngineProvider;
import org.pac4j.saml.crypto.KeyStoreDecryptionProvider;
import org.pac4j.saml.crypto.LogOnlySignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.logout.SAML2LogoutActionBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestMessageSender;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;
import org.pac4j.saml.logout.processor.SAML2LogoutProcessor;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.redirect.SAML2RedirectionActionBuilder;
import org.pac4j.saml.replay.InMemoryReplayCacheProvider;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.sso.artifact.DefaultSOAPPipelineProvider;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.sso.impl.SAML2AuthnResponseValidator;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageSender;
import org.pac4j.saml.state.SAML2StateGenerator;
import org.pac4j.saml.util.Configuration;

public class SAML2Client
extends IndirectClient {
    protected SAMLContextProvider contextProvider;
    protected SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected SAML2ResponseValidator authnResponseValidator;
    protected SAML2LogoutValidator logoutValidator;
    protected SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected SAML2MetadataResolver identityProviderMetadataResolver;
    protected SAML2MetadataResolver serviceProviderMetadataResolver;
    protected Decrypter decrypter;
    protected SAML2Configuration configuration;
    protected ValueGenerator stateGenerator = new SAML2StateGenerator(this);
    protected ReplayCacheProvider replayCache;
    protected SOAPPipelineProvider soapPipelineProvider;

    public SAML2Client() {
    }

    public SAML2Client(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        String callbackUrl = this.computeFinalCallbackUrl(null);
        this.configuration.setCallbackUrl(callbackUrl);
        this.configuration.init(forceReinit);
        this.initDecrypter();
        this.initSignatureSigningParametersProvider();
        this.initIdentityProviderMetadataResolver();
        this.initServiceProviderMetadataResolver();
        this.initSAMLContextProvider();
        this.initSignatureTrustEngineProvider();
        this.initSAMLReplayCache();
        this.initSAMLResponseValidator();
        this.initSOAPPipelineProvider();
        this.initSAMLLogoutResponseValidator();
        this.setRedirectionActionBuilderIfUndefined(new SAML2RedirectionActionBuilder(this));
        this.setCredentialsExtractorIfUndefined(new SAML2CredentialsExtractor(this, this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver, this.soapPipelineProvider));
        this.setAuthenticatorIfUndefined(new SAML2Authenticator(this.authnResponseValidator, this.logoutValidator, this.configuration.getAttributeAsId(), this.configuration.getMappedAttributes()));
        this.setLogoutProcessor(new SAML2LogoutProcessor(this));
        this.setLogoutActionBuilderIfUndefined(new SAML2LogoutActionBuilder(this));
    }

    protected void initSOAPPipelineProvider() {
        this.soapPipelineProvider = new DefaultSOAPPipelineProvider(this);
    }

    public SAML2LogoutRequestMessageSender getLogoutRequestMessageSender() {
        return new SAML2LogoutRequestMessageSender(this.signatureSigningParametersProvider, this.configuration.getSpLogoutRequestBindingType(), false, this.configuration.isSpLogoutRequestSigned());
    }

    public SAML2WebSSOMessageSender getSSOMessageSender() {
        return new SAML2WebSSOMessageSender(this.signatureSigningParametersProvider, this.configuration.getAuthnRequestBindingType(), true, this.configuration.isAuthnRequestSigned());
    }

    protected void initSAMLLogoutResponseValidator() {
        this.logoutValidator = new SAML2LogoutValidator(this.signatureTrustEngineProvider, this.decrypter, this.findSessionLogoutHandler(), this.replayCache, this.configuration.getUriComparator());
        this.logoutValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
        this.logoutValidator.setPartialLogoutTreatedAsSuccess(this.configuration.isPartialLogoutTreatedAsSuccess());
    }

    protected void initSAMLResponseValidator() {
        this.authnResponseValidator = new SAML2AuthnResponseValidator(this.signatureTrustEngineProvider, this.decrypter, this.replayCache, this.configuration, this.findSessionLogoutHandler());
        this.authnResponseValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
    }

    protected void initSignatureTrustEngineProvider() {
        this.signatureTrustEngineProvider = new ExplicitSignatureTrustEngineProvider(this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver);
        if (this.configuration.isAllSignatureValidationDisabled()) {
            this.signatureTrustEngineProvider = new LogOnlySignatureTrustEngineProvider(this.signatureTrustEngineProvider);
        }
    }

    protected void initSAMLContextProvider() {
        this.contextProvider = new SAML2ContextProvider(this.identityProviderMetadataResolver, this.serviceProviderMetadataResolver, this.configuration.getSamlMessageStoreFactory());
    }

    protected void initServiceProviderMetadataResolver() {
        this.serviceProviderMetadataResolver = new SAML2ServiceProviderMetadataResolver(this.configuration);
        this.serviceProviderMetadataResolver.resolve();
    }

    protected void initIdentityProviderMetadataResolver() {
        this.identityProviderMetadataResolver = this.configuration.getIdentityProviderMetadataResolver();
        this.identityProviderMetadataResolver.resolve();
    }

    protected void initDecrypter() {
        this.decrypter = new KeyStoreDecryptionProvider(this.configuration.getCredentialProvider()).build();
    }

    protected void initSignatureSigningParametersProvider() {
        this.signatureSigningParametersProvider = new DefaultSignatureSigningParametersProvider(this.configuration);
    }

    protected void initSAMLReplayCache() {
        this.replayCache = new InMemoryReplayCacheProvider();
    }

    public void destroy() {
        ((SAML2ServiceProviderMetadataResolver)this.serviceProviderMetadataResolver).destroy();
    }

    public void notifySessionRenewal(CallContext ctx, String oldSessionId) {
        SessionLogoutHandler sessionLogoutHandler = this.findSessionLogoutHandler();
        if (sessionLogoutHandler != null) {
            sessionLogoutHandler.renewSession(ctx, oldSessionId);
        }
    }

    public final String getIdentityProviderResolvedEntityId() {
        return this.identityProviderMetadataResolver.getEntityId();
    }

    public final String getServiceProviderResolvedEntityId() {
        return this.serviceProviderMetadataResolver.getEntityId();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAMLContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SignatureSigningParametersProvider getSignatureSigningParametersProvider() {
        return this.signatureSigningParametersProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2ResponseValidator getAuthnResponseValidator() {
        return this.authnResponseValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2LogoutValidator getLogoutValidator() {
        return this.logoutValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2SignatureTrustEngineProvider getSignatureTrustEngineProvider() {
        return this.signatureTrustEngineProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        return this.identityProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2MetadataResolver getServiceProviderMetadataResolver() {
        return this.serviceProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStateGenerator(ValueGenerator stateGenerator) {
        this.stateGenerator = stateGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReplayCacheProvider getReplayCache() {
        return this.replayCache;
    }

    static {
        CommonHelper.assertNotNull((String)"parserPool", (Object)Configuration.getParserPool());
        CommonHelper.assertNotNull((String)"marshallerFactory", (Object)Configuration.getMarshallerFactory());
        CommonHelper.assertNotNull((String)"unmarshallerFactory", (Object)Configuration.getUnmarshallerFactory());
        CommonHelper.assertNotNull((String)"builderFactory", (Object)Configuration.getBuilderFactory());
    }
}

