/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityRoleFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.resource.SpringResourceHelper;
import org.pac4j.core.resource.SpringResourceLoader;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2IdentityProviderMetadataResolver
extends SpringResourceLoader<MetadataResolver>
implements SAML2MetadataResolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2IdentityProviderMetadataResolver.class);
    private Proxy proxy = Proxy.NO_PROXY;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private final SAML2Configuration configuration;

    public SAML2IdentityProviderMetadataResolver(SAML2Configuration configuration) {
        super(configuration.getIdentityProviderMetadataResource());
        if (configuration.getSslSocketFactory() != null) {
            this.setSslSocketFactory(configuration.getSslSocketFactory());
        }
        if (configuration.getHostnameVerifier() != null) {
            this.setHostnameVerifier(configuration.getHostnameVerifier());
        }
        this.configuration = configuration;
    }

    @Override
    public final MetadataResolver resolve(boolean force) {
        if (force) {
            this.internalLoad();
        }
        return (MetadataResolver)this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalLoad() {
        long t0 = System.currentTimeMillis();
        try {
            this.loaded = this.initializeMetadataResolver();
        }
        finally {
            long t1 = System.currentTimeMillis();
            LOGGER.debug("Metadata resolution took: {} ms", (Object)(t1 - t0));
        }
    }

    protected DOMMetadataResolver initializeMetadataResolver() {
        Resource resource = this.configuration.getIdentityProviderMetadataResource();
        if (resource instanceof UrlResource) {
            UrlResource urlResource = (UrlResource)resource;
            String fileUrl = urlResource.getURL().toString();
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)new URL(fileUrl).openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection https = (HttpsURLConnection)conn;
                    if (this.hostnameVerifier != null) {
                        https.setHostnameVerifier(this.hostnameVerifier);
                    }
                    if (this.sslSocketFactory != null) {
                        https.setSSLSocketFactory(this.sslSocketFactory);
                    }
                }
                conn.setRequestMethod("HEAD");
                boolean supportsRange = "bytes".equalsIgnoreCase(conn.getHeaderField("Accept-Ranges"));
                if (supportsRange) {
                    long contentLength = conn.getContentLengthLong();
                    conn.disconnect();
                    DOMMetadataResolver dOMMetadataResolver = this.downloadMetadata(contentLength, fileUrl);
                    return dOMMetadataResolver;
                }
            }
            catch (Exception e) {
                throw new TechnicalException("Error getting idp metadata resource", (Throwable)e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return this.loadMetadataFromResource(this.configuration.getIdentityProviderMetadataResource());
    }

    private DOMMetadataResolver downloadMetadata(long contentLength, String url) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        long partSize = contentLength / (long)numThreads;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            File destination = Files.createTempFile("idpmetadata", ".xml", new FileAttribute[0]).toFile();
            LOGGER.debug("Downloading idp metadata to {}", (Object)destination.getAbsolutePath());
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (int i = 0; i < numThreads; ++i) {
                long l = (long)i * partSize;
                long end = i == numThreads - 1 ? contentLength - 1L : l + partSize - 1L;
                futures.add(executor.submit(() -> {
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    if (conn instanceof HttpsURLConnection) {
                        HttpsURLConnection https = (HttpsURLConnection)conn;
                        if (this.hostnameVerifier != null) {
                            https.setHostnameVerifier(this.hostnameVerifier);
                        }
                        if (this.sslSocketFactory != null) {
                            https.setSSLSocketFactory(this.sslSocketFactory);
                        }
                    }
                    conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
                    try (InputStream in = conn.getInputStream();
                         RandomAccessFile out = new RandomAccessFile(destination, "rw");){
                        out.seek(start);
                        byte[] buffer = new byte[8192];
                        int bytesRead = 0;
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        conn.disconnect();
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
            LOGGER.debug("Finished downloading idp metadata to {}", (Object)destination.getAbsolutePath());
            FileSystemResource resource = new FileSystemResource(destination);
            return this.loadMetadataFromResource((Resource)resource);
        }
        catch (Exception e) {
            throw new TechnicalException("Error downloading idp metadata", (Throwable)e);
        }
    }

    private DOMMetadataResolver loadMetadataFromResource(Resource resource) {
        DOMMetadataResolver dOMMetadataResolver;
        block11: {
            LOGGER.debug("Loading idp metadata from {}", (Object)resource);
            InputStream in = SpringResourceHelper.getResourceInputStream((Resource)resource, (Proxy)this.proxy, (SSLSocketFactory)this.sslSocketFactory, (HostnameVerifier)this.hostnameVerifier, (int)this.configuration.getIdentityProviderMetadataConnectTimeout(), (int)this.configuration.getIdentityProviderMetadataReadTimeout());
            try {
                Document parsedInput = Configuration.getParserPool().parse(in);
                Element metadataRoot = parsedInput.getDocumentElement();
                DOMMetadataResolver resolver = new DOMMetadataResolver(metadataRoot);
                resolver.setIndexes(Collections.singleton(new RoleMetadataIndex()));
                resolver.setParserPool(Configuration.getParserPool());
                resolver.setFailFastInitialization(true);
                resolver.setRequireValidMetadata(true);
                resolver.setId(resolver.getClass().getCanonicalName());
                EntityRoleFilter entityRoleFilter = new EntityRoleFilter(List.of(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
                entityRoleFilter.initialize();
                resolver.setMetadataFilter((MetadataFilter)entityRoleFilter);
                resolver.initialize();
                dOMMetadataResolver = resolver;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new TechnicalException("Error loading idp metadata", (Throwable)e);
                }
                catch (ComponentInitializationException e) {
                    throw new TechnicalException("Error initializing idp metadata resolver", (Throwable)e);
                }
                catch (XMLParserException e) {
                    throw new TechnicalException("Error parsing idp metadata", (Throwable)e);
                }
                catch (IOException e) {
                    throw new TechnicalException("Error getting idp metadata resource", (Throwable)e);
                }
            }
            in.close();
        }
        return dOMMetadataResolver;
    }

    protected String determineIdentityProviderEntityId() {
        Iterator it;
        String idpEntityId = this.configuration.getIdentityProviderEntityId();
        if (idpEntityId == null && (it = ((IterableMetadataSource)this.loaded).iterator()).hasNext()) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)it.next();
            idpEntityId = entityDescriptor.getEntityID();
        }
        if (idpEntityId == null) {
            throw new SAMLException("No idp entityId found");
        }
        return idpEntityId;
    }

    @Override
    public String getEntityId() {
        XMLObject md = this.getEntityDescriptorElement();
        if (md instanceof EntitiesDescriptor) {
            return ((EntityDescriptor)((EntitiesDescriptor)md).getEntityDescriptors().get(0)).getEntityID();
        }
        if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SAMLException("No idp entityId found");
    }

    @Override
    public String getMetadata() {
        if (this.getEntityDescriptorElement() != null) {
            return Configuration.serializeSamlObject(this.getEntityDescriptorElement()).toString();
        }
        throw new TechnicalException("Metadata cannot be retrieved because entity descriptor is null");
    }

    @Override
    public final XMLObject getEntityDescriptorElement() {
        try {
            String idpEntityId = this.determineIdentityProviderEntityId();
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(idpEntityId)}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

