/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.sql.profile.service;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.MultipleAccountsFoundException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.TestsConstants;
import org.pac4j.core.util.TestsHelper;
import org.pac4j.sql.profile.DbProfile;
import org.pac4j.sql.profile.service.DbProfileService;
import org.pac4j.sql.test.tools.DbServer;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public final class DbProfileServiceTests
implements TestsConstants {
    private static final int DB_ID = 100000000;
    private static final String DB_LINKED_ID = "dbLinkedId";
    private static final String DB_PASS = "dbPass";
    private static final String DB_USER = "dbUser";
    private static final String DB_USER2 = "dbUser2";
    private DataSource ds = DbServer.getInstance();

    @Test
    public void testNullPasswordEncoder() {
        DbProfileService dbProfileService = new DbProfileService(this.ds, "firstname");
        TestsHelper.expectException(() -> dbProfileService.validate(null, null), TechnicalException.class, (String)"passwordEncoder cannot be null");
    }

    @Test
    public void testNullDataSource() {
        DbProfileService dbProfileService = new DbProfileService(null, "firstname");
        dbProfileService.setPasswordEncoder(DbServer.PASSWORD_ENCODER);
        TestsHelper.expectException(() -> dbProfileService.validate(null, null), TechnicalException.class, (String)"dataSource cannot be null");
    }

    private UsernamePasswordCredentials login(String username, String password, String attribute) {
        DbProfileService dbProfileService = new DbProfileService(this.ds, attribute);
        dbProfileService.setPasswordEncoder(DbServer.PASSWORD_ENCODER);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        dbProfileService.validate(credentials, null);
        return credentials;
    }

    @Test
    public void testGoodUsernameAttribute() {
        UsernamePasswordCredentials credentials = this.login("jle", "password", "firstname");
        CommonProfile profile = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((boolean)(profile instanceof DbProfile));
        DbProfile dbProfile = (DbProfile)profile;
        Assert.assertEquals((Object)"jle", (Object)dbProfile.getId());
        Assert.assertEquals((Object)"Jerome", (Object)dbProfile.getAttribute("firstname"));
    }

    @Test
    public void testGoodUsernameNoAttribute() {
        UsernamePasswordCredentials credentials = this.login("jle", "password", "");
        CommonProfile profile = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((boolean)(profile instanceof DbProfile));
        DbProfile dbProfile = (DbProfile)profile;
        Assert.assertEquals((Object)"jle", (Object)dbProfile.getId());
        Assert.assertNull((Object)dbProfile.getAttribute("firstname"));
    }

    @Test
    public void testMultipleUsername() {
        TestsHelper.expectException(() -> this.login("misagh", "password", ""), MultipleAccountsFoundException.class, (String)"Too many accounts found for: misagh");
    }

    @Test
    public void testBadUsername() {
        TestsHelper.expectException(() -> this.login("michael", "password", ""), AccountNotFoundException.class, (String)"No account found for: michael");
    }

    @Test
    public void testBadPassword() {
        TestsHelper.expectException(() -> this.login("jle", "passwordbad", ""), BadCredentialsException.class, (String)"Bad credentials for: jle");
    }

    @Test
    public void testCreateUpdateFindDelete() {
        DbProfile profile = new DbProfile();
        profile.setId("100000000");
        profile.setLinkedId(DB_LINKED_ID);
        profile.addAttribute("username", (Object)DB_USER);
        DbProfileService dbProfileService = new DbProfileService(this.ds);
        dbProfileService.setPasswordEncoder(DbServer.PASSWORD_ENCODER);
        dbProfileService.create((CommonProfile)profile, DB_PASS);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(DB_USER, DB_PASS);
        dbProfileService.validate(credentials, null);
        CommonProfile profile1 = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile1);
        List<Map<String, Object>> results = this.getData(100000000);
        Assert.assertEquals((long)1L, (long)results.size());
        Map<String, Object> result = results.get(0);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)100000000, (Object)result.get("id"));
        Assert.assertEquals((Object)DB_LINKED_ID, (Object)result.get("linkedid"));
        Assert.assertNotNull((Object)result.get("serializedprofile"));
        Assert.assertTrue((boolean)DbServer.PASSWORD_ENCODER.matches(DB_PASS, (String)result.get("password")));
        Assert.assertEquals((Object)DB_USER, (Object)result.get("username"));
        DbProfile profile2 = (DbProfile)dbProfileService.findById("100000000");
        Assert.assertEquals((Object)"100000000", (Object)profile2.getId());
        Assert.assertEquals((Object)DB_LINKED_ID, (Object)profile2.getLinkedId());
        Assert.assertEquals((Object)DB_USER, (Object)profile2.getUsername());
        Assert.assertEquals((long)1L, (long)profile2.getAttributes().size());
        profile.addAttribute("username", (Object)DB_USER2);
        dbProfileService.update((CommonProfile)profile, null);
        List<Map<String, Object>> results2 = this.getData(100000000);
        Assert.assertEquals((long)1L, (long)results2.size());
        Map<String, Object> result2 = results2.get(0);
        Assert.assertEquals((long)5L, (long)result2.size());
        Assert.assertEquals((Object)100000000, (Object)result2.get("id"));
        Assert.assertEquals((Object)DB_LINKED_ID, (Object)result2.get("linkedid"));
        Assert.assertNotNull((Object)result2.get("serializedprofile"));
        Assert.assertTrue((boolean)DbServer.PASSWORD_ENCODER.matches(DB_PASS, (String)result2.get("password")));
        Assert.assertEquals((Object)DB_USER2, (Object)result2.get("username"));
        dbProfileService.remove((CommonProfile)profile);
        List<Map<String, Object>> results3 = this.getData(100000000);
        Assert.assertEquals((long)0L, (long)results3.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getData(int id) {
        DBI dbi = new DBI(this.ds);
        try (Handle h = null;){
            h = dbi.open();
            List list = ((Query)h.createQuery("select id,username,linkedid,password,serializedprofile from users where id = :id").bind("id", id)).list(2);
            return list;
        }
    }
}

