/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.sql.profile.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.service.AbstractProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.sql.profile.DbProfile;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class DbProfileService
extends AbstractProfileService<DbProfile> {
    protected DBI dbi;
    private String usersTable = "users";
    private DataSource dataSource;

    public DbProfileService() {
    }

    public DbProfileService(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbProfileService(DataSource dataSource, String attributes) {
        this.dataSource = dataSource;
        this.setAttributes(attributes);
    }

    public DbProfileService(DataSource dataSource, String attributes, PasswordEncoder passwordEncoder) {
        this.dataSource = dataSource;
        this.setAttributes(attributes);
        this.setPasswordEncoder(passwordEncoder);
    }

    public DbProfileService(DataSource dataSource, PasswordEncoder passwordEncoder) {
        this.dataSource = dataSource;
        this.setPasswordEncoder(passwordEncoder);
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"passwordEncoder", (Object)this.getPasswordEncoder());
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new DbProfile()));
        CommonHelper.assertNotNull((String)"dataSource", (Object)this.dataSource);
        this.dbi = new DBI(this.dataSource);
        super.internalInit();
    }

    protected void insert(Map<String, Object> attributes) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> questionMarks = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            names.add(entry.getKey());
            questionMarks.add("?");
            values.add(entry.getValue());
        }
        String query = "insert into " + this.usersTable + " (" + this.buildAttributesList(names) + ") values (" + this.buildAttributesList(questionMarks) + ")";
        this.execute(query, values.toArray());
    }

    protected void update(Map<String, Object> attributes) {
        StringBuffer attributesList = new StringBuffer();
        String id = null;
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if ("id".equals(name)) {
                id = (String)value;
                continue;
            }
            if (i > 0) {
                attributesList.append(",");
            }
            attributesList.append(name);
            attributesList.append("= :");
            attributesList.append(name);
            values.add(value);
            ++i;
        }
        CommonHelper.assertNotNull((String)"id", id);
        values.add(id);
        String query = "update " + this.usersTable + " set " + attributesList.toString() + " where " + this.getIdAttribute() + " = :id";
        this.execute(query, values.toArray());
    }

    protected void deleteById(String id) {
        String query = "delete from " + this.usersTable + " where " + this.getIdAttribute() + " = :id";
        this.execute(query, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String query, Object ... args) {
        try (Handle h = null;){
            h = this.dbi.open();
            this.logger.debug("Execute query: {} and values: {}", (Object)query, (Object)args);
            h.execute(query, args);
        }
    }

    protected List<Map<String, Object>> read(List<String> names, String key, String value) {
        String attributesList = this.buildAttributesList(names);
        String query = "select " + attributesList + " from " + this.usersTable + " where " + key + " = :" + key;
        return this.query(query, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> query(String query, String key, String value) {
        try (Handle h = null;){
            h = this.dbi.open();
            this.logger.debug("Query: {} for key/value: {} / {}", new Object[]{query, key, value});
            List list = ((Query)h.createQuery(query).bind(key, value)).list(2);
            return list;
        }
    }

    protected String buildAttributesList(List<String> names) {
        StringBuffer sb = new StringBuffer();
        boolean firstOne = true;
        for (String name : names) {
            if (!firstOne) {
                sb.append(",");
            }
            sb.append(name);
            firstOne = false;
        }
        return sb.toString();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getUsersTable() {
        return this.usersTable;
    }

    public void setUsersTable(String usersTable) {
        CommonHelper.assertNotBlank((String)"usersTable", (String)usersTable);
        this.usersTable = usersTable;
    }

    public DBI getDbi() {
        return this.dbi;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"dataSource", this.dataSource, "passwordEncoder", this.getPasswordEncoder(), "attributes", this.getAttributes(), "profileDefinition", this.getProfileDefinition(), "usersTable", this.usersTable, "idAttribute", this.getIdAttribute(), "usernameAttribute", this.getUsernameAttribute(), "passwordAttribute", this.getPasswordAttribute()});
    }
}

