/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.store.PlaySessionStore;
import play.libs.concurrent.HttpExecutionContext;
import play.mvc.Controller;
import play.mvc.Result;

public class CallbackController
extends Controller {
    private CallbackLogic<Result, PlayWebContext> callbackLogic = new DefaultCallbackLogic();
    private String defaultUrl;
    private Boolean saveInSession;
    private Boolean multiProfile;
    private Boolean renewSession;
    private String defaultClient;
    @Inject
    protected Config config;
    @Inject
    protected PlaySessionStore playSessionStore;
    @Inject
    protected HttpExecutionContext ec;

    public CompletionStage<Result> callback() {
        CommonHelper.assertNotNull((String)"callbackLogic", this.callbackLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        PlayWebContext playWebContext = new PlayWebContext(CallbackController.ctx(), (SessionStore<PlayWebContext>)this.playSessionStore);
        return CompletableFuture.supplyAsync(() -> (Result)this.callbackLogic.perform((WebContext)playWebContext, this.config, this.config.getHttpActionAdapter(), this.defaultUrl, this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient), this.ec.current());
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public boolean isMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setCallbackLogic(CallbackLogic<Result, PlayWebContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }
}

