/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.ScalaCompatibility;
import play.api.mvc.AnyContentAsFormUrlEncoded;
import play.api.mvc.RequestHeader;
import play.core.j.JavaHelpers$;
import play.libs.typedmap.TypedKey;
import play.mvc.Http;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public class PlayWebContext
implements WebContext {
    public static final TypedKey<Object> PAC4J_USER_PROFILES = TypedKey.create((String)"pac4jUserProfiles");
    protected final Http.Context context;
    protected final Http.Request request;
    protected final Http.Response response;
    protected final Http.Session session;
    protected java.util.Map<String, String[]> formParameters = null;
    protected SessionStore<PlayWebContext> sessionStore;
    protected String responseContent = "";

    public PlayWebContext(Http.Context context, SessionStore<PlayWebContext> sessionStore) {
        this.context = context;
        this.request = context.request();
        this.response = context.response();
        this.session = context.session();
        CommonHelper.assertNotNull((String)"sessionStore", sessionStore);
        this.sessionStore = sessionStore;
    }

    public PlayWebContext(RequestHeader requestHeader, SessionStore<PlayWebContext> sessionStore) {
        this(JavaHelpers$.MODULE$.createJavaContext(requestHeader, JavaHelpers$.MODULE$.createContextComponents()), sessionStore);
    }

    public PlayWebContext(RequestHeader requestHeader, Object body, SessionStore<PlayWebContext> sessionStore) {
        this(JavaHelpers$.MODULE$.createJavaContext(requestHeader, JavaHelpers$.MODULE$.createContextComponents()), sessionStore);
        this.formParameters = new HashMap<String, String[]>();
        if (body instanceof AnyContentAsFormUrlEncoded) {
            Map parameters = (Map)((AnyContentAsFormUrlEncoded)body).asFormUrlEncoded().get();
            for (String key : ScalaCompatibility.scalaSetToJavaSet(parameters.keySet())) {
                Seq v = (Seq)parameters.get((Object)key).get();
                String[] values = new String[v.size()];
                v.copyToArray((Object)values);
                this.formParameters.put(key, values);
            }
        }
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public Http.Session getJavaSession() {
        return this.session;
    }

    public Http.Context getJavaContext() {
        return this.context;
    }

    public void setResponseStatus(int code) {
    }

    public void writeResponseContent(String content) {
        if (content != null) {
            this.responseContent = this.responseContent + content;
        }
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public String getRequestHeader(String name) {
        return this.request.header(name).orElse(null);
    }

    public String getRequestMethod() {
        return this.request.method();
    }

    public String getRequestParameter(String name) {
        java.util.Map<String, String[]> parameters = this.getRequestParameters();
        String[] values = parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public java.util.Map<String, String[]> getRequestParameters() {
        java.util.Map p;
        Http.RequestBody body;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        if (this.formParameters != null) {
            parameters.putAll(this.formParameters);
        } else if (this.request.hasBody() && (body = this.request.body()) != null && (p = body.asFormUrlEncoded()) != null) {
            parameters.putAll(p);
        }
        java.util.Map urlParameters = this.request.queryString();
        if (urlParameters != null) {
            parameters.putAll(urlParameters);
        }
        return parameters;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String getServerName() {
        String[] split = this.request.host().split(":");
        return split[0];
    }

    public int getServerPort() {
        String defaultPort = this.request.secure() ? "443" : "80";
        String[] split = this.request.host().split(":");
        String portStr = split.length > 1 ? split[1] : defaultPort;
        return Integer.parseInt(portStr);
    }

    public String getScheme() {
        if (this.request.secure()) {
            return "https";
        }
        return "http";
    }

    public boolean isSecure() {
        return this.request.secure();
    }

    public String getFullRequestURL() {
        return this.getScheme() + "://" + this.request.host() + this.request.uri();
    }

    public String getRemoteAddr() {
        return this.request.remoteAddress();
    }

    public Object getRequestAttribute(String name) {
        Optional optionalValue;
        Object value = this.context.args.get(name);
        if ("pac4jUserProfiles".equals(name) && value == null && (optionalValue = this.request.attrs().getOptional(PAC4J_USER_PROFILES)).isPresent()) {
            value = optionalValue.get();
        }
        return value;
    }

    public void setRequestAttribute(String name, Object value) {
        this.context.args.put(name, value);
    }

    public Collection<Cookie> getRequestCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Http.Cookies httpCookies = this.request.cookies();
        httpCookies.forEach(httpCookie -> {
            Cookie cookie = new Cookie(httpCookie.name(), httpCookie.value());
            if (httpCookie.domain() != null) {
                cookie.setDomain(httpCookie.domain());
            }
            cookie.setHttpOnly(httpCookie.httpOnly());
            if (httpCookie.maxAge() != null) {
                cookie.setMaxAge(httpCookie.maxAge().intValue());
            }
            cookie.setPath(httpCookie.path());
            cookie.setSecure(httpCookie.secure());
            cookies.add(cookie);
        });
        return cookies;
    }

    public String getPath() {
        return this.request.path();
    }

    public void addResponseCookie(Cookie cookie) {
        Http.CookieBuilder cookieBuilder = Http.Cookie.builder((String)cookie.getName(), (String)cookie.getValue()).withPath(cookie.getPath()).withDomain(cookie.getDomain()).withSecure(cookie.isSecure()).withHttpOnly(cookie.isHttpOnly());
        int maxAge = cookie.getMaxAge();
        if (maxAge != -1) {
            cookieBuilder.withMaxAge(Duration.of(maxAge, ChronoUnit.SECONDS));
        }
        Http.Cookie responseCookie = cookieBuilder.build();
        this.response.setCookie(responseCookie);
    }

    public void setResponseContentType(String content) {
        this.response.setHeader("Content-Type", content);
    }

    public String getLocation() {
        return (String)this.context.response().getHeaders().get("Location");
    }
}

