/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.deadbolt2;

import be.objectify.deadbolt.java.DeadboltHandler;
import be.objectify.deadbolt.java.DynamicResourceHandler;
import be.objectify.deadbolt.java.models.Permission;
import be.objectify.deadbolt.java.models.Subject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.deadbolt2.Pac4jRoleHandler;
import org.pac4j.play.deadbolt2.Pac4jSubject;
import org.pac4j.play.store.PlaySessionStore;
import play.libs.concurrent.HttpExecutionContext;
import play.mvc.Http;
import play.mvc.Result;

public class Pac4jHandler
extends DefaultSecurityLogic<Result, PlayWebContext>
implements DeadboltHandler {
    private final Config config;
    private final HttpExecutionContext httpExecutionContext;
    private final String clients;
    private final PlaySessionStore playSessionStore;
    private final Pac4jRoleHandler rolePermissionsHandler;

    public Pac4jHandler(Config config, HttpExecutionContext httpExecutionContext, String clients, PlaySessionStore playSessionStore, Pac4jRoleHandler rolePermissionsHandler) {
        CommonHelper.assertNotNull((String)"config", (Object)config);
        CommonHelper.assertNotNull((String)"httpExecutionContext", (Object)httpExecutionContext);
        CommonHelper.assertNotNull((String)"playSessionStore", (Object)playSessionStore);
        this.config = config;
        this.httpExecutionContext = httpExecutionContext;
        this.clients = clients;
        this.playSessionStore = playSessionStore;
        this.rolePermissionsHandler = rolePermissionsHandler;
    }

    public CompletionStage<Optional<Result>> beforeAuthCheck(Http.Context context) {
        return CompletableFuture.supplyAsync(() -> {
            HttpAction action;
            Optional<CommonProfile> profile = this.getProfile(context);
            if (profile.isPresent()) {
                this.logger.debug("profile found -> returning empty");
                return Optional.empty();
            }
            PlayWebContext playWebContext = new PlayWebContext(context, (SessionStore<PlayWebContext>)this.playSessionStore);
            HttpActionAdapter httpActionAdapter = this.config.getHttpActionAdapter();
            List currentClients = this.getClientFinder().find(this.config.getClients(), (WebContext)playWebContext, this.clients);
            this.logger.debug("currentClients: {}", (Object)currentClients);
            try {
                if (this.startDirectAuthentication(currentClients)) {
                    CommonProfile userProfile;
                    this.logger.debug("Starting direct authentication");
                    DirectClient client = (DirectClient)currentClients.get(0);
                    Credentials credentials = client.getCredentials((WebContext)playWebContext);
                    if (credentials != null && (userProfile = credentials.getUserProfile()) != null) {
                        this.setProfile(context, userProfile);
                        return Optional.empty();
                    }
                    this.logger.debug("unauthorized");
                    action = this.unauthorized(playWebContext, currentClients);
                } else if (this.startAuthentication(playWebContext, currentClients)) {
                    this.logger.debug("Starting authentication");
                    this.saveRequestedUrl(playWebContext, currentClients);
                    action = this.redirectToIdentityProvider(playWebContext, currentClients);
                } else {
                    this.logger.debug("unauthorized");
                    action = this.unauthorized(playWebContext, currentClients);
                }
            }
            catch (HttpAction e) {
                action = e;
            }
            return Optional.of(httpActionAdapter.adapt(action.getCode(), (WebContext)playWebContext));
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<Optional<? extends Subject>> getSubject(Http.Context context) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<CommonProfile> profile = this.getProfile(context);
            if (profile.isPresent()) {
                this.logger.debug("profile found: {} -> building a subject", profile);
                return Optional.of(new Pac4jSubject(profile.get()));
            }
            this.logger.debug("no profile found -> returning empty");
            return Optional.empty();
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<List<? extends Permission>> getPermissionsForRole(String roleName) {
        return this.rolePermissionsHandler.getPermissionsForRole(this.clients, roleName, this.httpExecutionContext);
    }

    private Optional<CommonProfile> getProfile(Http.Context context) {
        PlayWebContext playWebContext = new PlayWebContext(context, (SessionStore<PlayWebContext>)this.playSessionStore);
        ProfileManager manager = new ProfileManager((WebContext)playWebContext);
        return manager.get(true);
    }

    private void setProfile(Http.Context context, CommonProfile profile) {
        PlayWebContext playWebContext = new PlayWebContext(context, (SessionStore<PlayWebContext>)this.playSessionStore);
        playWebContext.setRequestAttribute("pac4jUserProfiles", profile);
    }

    public CompletionStage<Result> onAuthFailure(Http.Context context, Optional<String> content) {
        return CompletableFuture.supplyAsync(() -> {
            PlayWebContext playWebContext = new PlayWebContext(context, (SessionStore<PlayWebContext>)this.playSessionStore);
            HttpActionAdapter httpActionAdapter = this.config.getHttpActionAdapter();
            return (Result)httpActionAdapter.adapt(403, (WebContext)playWebContext);
        }, this.httpExecutionContext.current());
    }

    public CompletionStage<Optional<DynamicResourceHandler>> getDynamicResourceHandler(Http.Context context) {
        throw new TechnicalException("getDynamicResourceHandler() not supported in Pac4jHandler");
    }

    private boolean startDirectAuthentication(List<Client> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof DirectClient;
    }
}

