/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.deadbolt2;

import be.objectify.deadbolt.java.DeadboltHandler;
import be.objectify.deadbolt.java.cache.HandlerCache;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.pac4j.core.config.Config;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.deadbolt2.Pac4jHandler;
import org.pac4j.play.deadbolt2.Pac4jRoleHandler;
import org.pac4j.play.store.PlaySessionStore;
import play.libs.concurrent.HttpExecutionContext;

@Singleton
public class Pac4jHandlerCache
implements HandlerCache {
    private final Map<String, DeadboltHandler> handlers = new HashMap<String, DeadboltHandler>();
    private Config config;
    private HttpExecutionContext httpExecutionContext;
    private PlaySessionStore playSessionStore;
    private DeadboltHandler defaultHandler;
    private final Pac4jRoleHandler roleHandler;

    @Inject
    public Pac4jHandlerCache(Config config, HttpExecutionContext httpExecutionContext, PlaySessionStore playSessionStore, Pac4jRoleHandler roleHandler) {
        this.config = config;
        this.httpExecutionContext = httpExecutionContext;
        this.playSessionStore = playSessionStore;
        this.roleHandler = roleHandler;
        this.defaultHandler = new Pac4jHandler(config, httpExecutionContext, null, playSessionStore, roleHandler);
        this.handlers.put("defaultHandler", this.defaultHandler);
    }

    public DeadboltHandler apply(String clients) {
        DeadboltHandler handler = this.handlers.get(clients);
        if (handler == null) {
            handler = this.getAndBuildHandler(clients);
        }
        return handler;
    }

    protected synchronized DeadboltHandler getAndBuildHandler(String clients) {
        DeadboltHandler handler = this.handlers.get(clients);
        if (handler == null) {
            handler = new Pac4jHandler(this.config, this.httpExecutionContext, clients, this.playSessionStore, this.roleHandler);
        }
        return handler;
    }

    public DeadboltHandler get() {
        return this.defaultHandler;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"handlers", this.handlers, "config", this.config, "httpExecutionContext", this.httpExecutionContext, "playSessionStore", this.playSessionStore});
    }
}

