/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.http;

import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.play.PlayWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Result;
import play.mvc.Results;

public class PlayHttpActionAdapter
implements HttpActionAdapter<Result, PlayWebContext> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Result adapt(int code, PlayWebContext context) {
        this.logger.debug("requires HTTP action: {}", (Object)code);
        if (code == 401) {
            return Results.unauthorized((String)"authentication required");
        }
        if (code == 403) {
            return Results.forbidden((String)"forbidden");
        }
        if (code == 302) {
            return Results.redirect((String)context.getLocation());
        }
        if (code == 400) {
            return Results.badRequest((String)"bad request");
        }
        if (code == 200) {
            String content = context.getResponseContent();
            this.logger.debug("render: {}", (Object)content);
            return Results.ok((String)content).as("text/html; charset=utf-8");
        }
        if (code == 204) {
            return Results.noContent();
        }
        String message = "Unsupported HTTP action: " + code;
        this.logger.error(message);
        throw new TechnicalException(message);
    }
}

