/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.java.Secure;
import org.pac4j.play.store.PlaySessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class SecureAction
extends Action<Result> {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SecurityLogic<CompletionStage<Result>, PlayWebContext> securityLogic = new DefaultSecurityLogic();
    protected static final Method CLIENTS_METHOD;
    protected static final Method AUTHORIZERS_METHOD;
    protected static final Method MATCHERS_METHOD;
    protected static final Method MULTI_PROFILE_METHOD;
    private final Config config;
    private final SessionStore sessionStore;

    @Inject
    public SecureAction(Config config, PlaySessionStore playSessionStore) {
        this.config = config;
        this.config.setSessionStore((SessionStore)playSessionStore);
        SecurityLogic configSecurityLogic = config.getSecurityLogic();
        if (configSecurityLogic != null) {
            this.securityLogic = configSecurityLogic;
        }
        this.sessionStore = playSessionStore;
    }

    public CompletionStage<Result> call(Http.Context ctx) {
        try {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.configuration);
            String clients = this.getStringParam(invocationHandler, CLIENTS_METHOD, null);
            String authorizers = this.getStringParam(invocationHandler, AUTHORIZERS_METHOD, null);
            String matchers = this.getStringParam(invocationHandler, MATCHERS_METHOD, null);
            boolean multiProfile = this.getBooleanParam(invocationHandler, MULTI_PROFILE_METHOD, false);
            return this.internalCall(ctx, clients, authorizers, matchers, multiProfile);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public CompletionStage<Result> internalCall(Http.Context ctx, String clients, String authorizers, String matchers, boolean multiProfile) throws Throwable {
        CommonHelper.assertNotNull((String)"securityLogic", this.securityLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        PlayWebContext playWebContext = new PlayWebContext(ctx, (SessionStore<PlayWebContext>)this.sessionStore);
        HttpActionAdapter actionAdapter = this.config.getHttpActionAdapter();
        CommonHelper.assertNotNull((String)"actionAdapter", (Object)actionAdapter);
        HttpActionAdapter actionAdapterWrapper = (code, webCtx) -> CompletableFuture.completedFuture(actionAdapter.adapt(code, webCtx));
        return (CompletionStage)this.securityLogic.perform((WebContext)playWebContext, this.config, (webCtx, profiles, parameters) -> {
            if (this.delegate == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.delegate.call(ctx);
        }, actionAdapterWrapper, clients, authorizers, matchers, Boolean.valueOf(multiProfile), new Object[0]);
    }

    protected String getStringParam(InvocationHandler invocationHandler, Method method, String defaultValue) throws Throwable {
        String value = (String)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        this.logger.debug("String param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    protected boolean getBooleanParam(InvocationHandler invocationHandler, Method method, boolean defaultValue) throws Throwable {
        Boolean value = (Boolean)invocationHandler.invoke(this.configuration, method, null);
        if (value == null) {
            value = defaultValue;
        }
        this.logger.debug("Boolean param: {}: {}", (Object)method.getName(), (Object)value);
        return value;
    }

    public SecurityLogic<CompletionStage<Result>, PlayWebContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<CompletionStage<Result>, PlayWebContext> securityLogic) {
        this.securityLogic = securityLogic;
    }

    static {
        try {
            CLIENTS_METHOD = Secure.class.getDeclaredMethod("clients", new Class[0]);
            AUTHORIZERS_METHOD = Secure.class.getDeclaredMethod("authorizers", new Class[0]);
            MATCHERS_METHOD = Secure.class.getDeclaredMethod("matchers", new Class[0]);
            MULTI_PROFILE_METHOD = Secure.class.getDeclaredMethod("multiProfile", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

