/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.store.PlayCacheStore;
import org.pac4j.play.store.PlaySessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.cache.SyncCacheApi;
import play.mvc.Http;

@Singleton
public class PlayCacheSessionStore
implements PlaySessionStore {
    private static final Logger logger = LoggerFactory.getLogger(PlayCacheSessionStore.class);
    private String prefix = null;
    private final PlayCacheStore<String, Map<String, Object>> store;

    @Inject
    public PlayCacheSessionStore(SyncCacheApi cache) {
        this.store = new PlayCacheStore(cache);
        this.setDefaultTimeout();
    }

    public PlayCacheSessionStore(Provider<SyncCacheApi> cacheProvider) {
        this.store = new PlayCacheStore(cacheProvider);
        this.setDefaultTimeout();
    }

    String getPrefixedSessionKey(String sessionId) {
        if (this.prefix != null) {
            return this.prefix + sessionId;
        }
        return sessionId;
    }

    public String getOrCreateSessionId(PlayWebContext context) {
        Http.Session session = context.getJavaSession();
        String sessionId = session.get((Object)"pac4jSessionId");
        logger.trace("retrieved sessionId: {}", (Object)sessionId);
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            logger.debug("generated sessionId: {}", (Object)sessionId);
            session.put("pac4jSessionId", sessionId);
        }
        return sessionId;
    }

    public Object get(PlayWebContext context, String key) {
        String sessionId = this.getOrCreateSessionId(context);
        Map values = (Map)this.store.get(this.getPrefixedSessionKey(sessionId));
        Object value = null;
        if (values != null) {
            value = values.get(key);
        }
        logger.trace("get, sessionId = {}, key = {} -> {}", new Object[]{sessionId, key, value});
        return value;
    }

    public void set(PlayWebContext context, String key, Object value) {
        String sessionId = this.getOrCreateSessionId(context);
        String prefixedSessionKey = this.getPrefixedSessionKey(sessionId);
        HashMap<String, Object> values = (HashMap<String, Object>)this.store.get(prefixedSessionKey);
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        logger.trace("set, sessionId = {}, key = {}, value = {}", new Object[]{sessionId, key, value});
        values.put(key, value);
        this.store.set(prefixedSessionKey, values);
    }

    public boolean destroySession(PlayWebContext context) {
        Http.Session session = context.getJavaSession();
        String sessionId = session.get((Object)"pac4jSessionId");
        if (sessionId != null) {
            session.clear();
            return true;
        }
        return false;
    }

    public Object getTrackableSession(PlayWebContext context) {
        return context.getJavaSession().get((Object)"pac4jSessionId");
    }

    public SessionStore<PlayWebContext> buildFromTrackableSession(PlayWebContext context, Object trackableSession) {
        context.getJavaSession().put("pac4jSessionId", (String)trackableSession);
        return this;
    }

    public boolean renewSession(PlayWebContext context) {
        String oldSessionId = this.getOrCreateSessionId(context);
        Map oldData = (Map)this.store.get(this.getPrefixedSessionKey(oldSessionId));
        Http.Session session = context.getJavaSession();
        session.remove((Object)"pac4jSessionId");
        String newSessionId = this.getOrCreateSessionId(context);
        if (oldData != null) {
            this.store.set(this.getPrefixedSessionKey(newSessionId), oldData);
        }
        logger.debug("Renewing session: {} -> {}", (Object)oldSessionId, (Object)newSessionId);
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getTimeout() {
        return this.store.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.store.setTimeout(timeout);
    }

    public PlayCacheStore<String, Map<String, Object>> getStore() {
        return this.store;
    }

    protected void setDefaultTimeout() {
        this.store.setTimeout(3600);
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"store", this.store, "prefix", this.prefix, "timeout", this.getTimeout()});
    }
}

