/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import com.google.inject.Provider;
import java.io.Serializable;
import javax.inject.Inject;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.store.AbstractStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.JavaSerializationHelper;
import play.cache.SyncCacheApi;

public class PlayCacheStore<K, O>
extends AbstractStore<K, O> {
    public static final JavaSerializationHelper JAVA_SERIALIZATION_HELPER = new JavaSerializationHelper();
    private final SyncCacheApi cache;
    private final Provider<SyncCacheApi> cacheProvider;
    private int timeout;

    @Inject
    public PlayCacheStore(SyncCacheApi cacheApi) {
        this.cacheProvider = null;
        this.cache = cacheApi;
    }

    public PlayCacheStore(Provider<SyncCacheApi> cacheProvider) {
        this.cache = null;
        this.cacheProvider = cacheProvider;
    }

    protected void internalInit() {
        CommonHelper.assertTrue((this.timeout >= 0 ? 1 : 0) != 0, (String)"timeout must be greater than zero");
        if (this.cache == null && this.cacheProvider == null) {
            throw new TechnicalException("The cache and the cacheProvider must not be both null");
        }
    }

    protected O internalGet(K key) {
        return (O)this.getCache().get(this.computeKey(key));
    }

    protected void internalSet(K key, O value) {
        this.getCache().set(this.computeKey(key), value, this.timeout);
    }

    protected void internalRemove(K key) {
        this.getCache().remove(this.computeKey(key));
    }

    protected String computeKey(Object objKey) {
        if (objKey instanceof String) {
            return (String)objKey;
        }
        return JAVA_SERIALIZATION_HELPER.serializeToBase64((Serializable)objKey);
    }

    public SyncCacheApi getCache() {
        return this.cache != null ? this.cache : (SyncCacheApi)this.cacheProvider.get();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"cache", this.getCache(), "timeout", this.timeout});
    }
}

