/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.play.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.JavaSerializationHelper;
import org.pac4j.play.PlayWebContext;
import org.pac4j.play.store.DataEncrypter;
import org.pac4j.play.store.PlaySessionStore;
import org.pac4j.play.store.ShiroAesDataEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;

@Singleton
public class PlayCookieSessionStore
implements PlaySessionStore {
    private static final Logger logger = LoggerFactory.getLogger(PlayCookieSessionStore.class);
    private final String tokenName = "pac4j";
    private final String keyPrefix = "pac4j_";
    private DataEncrypter dataEncrypter = new ShiroAesDataEncrypter();
    public static final JavaSerializationHelper JAVA_SER_HELPER = new JavaSerializationHelper();

    public PlayCookieSessionStore() {
    }

    public PlayCookieSessionStore(DataEncrypter dataEncrypter) {
        this.dataEncrypter = dataEncrypter;
    }

    public String getOrCreateSessionId(PlayWebContext context) {
        return "pac4j";
    }

    public Object get(PlayWebContext context, String key) {
        Http.Session session = context.getJavaSession();
        String sessionValue = session.get((Object)("pac4j_" + key));
        if (sessionValue == null) {
            logger.trace("get, key = {} -> null", (Object)key);
            return null;
        }
        byte[] inputBytes = Base64.decodeBase64((String)sessionValue);
        Serializable value = JAVA_SER_HELPER.unserializeFromBytes(PlayCookieSessionStore.uncompressBytes(this.dataEncrypter.decrypt(inputBytes)));
        logger.trace("get, key = {} -> value = {}", (Object)key, (Object)value);
        return value;
    }

    public void set(PlayWebContext context, String key, Object value) {
        logger.trace("set, key = {}, value = {}", (Object)key, value);
        Object clearedValue = value;
        if (key.contentEquals("pac4jUserProfiles")) {
            clearedValue = this.clearUserProfiles(value);
        }
        Http.Session session = context.getJavaSession();
        byte[] javaSerBytes = JAVA_SER_HELPER.serializeToBytes((Serializable)clearedValue);
        String serialized = Base64.encodeBase64String((byte[])this.dataEncrypter.encrypt(PlayCookieSessionStore.compressBytes(javaSerBytes)));
        if (serialized != null) {
            logger.trace("set, key = {} -> serialized token size = {}", (Object)key, (Object)serialized.length());
        } else {
            logger.trace("set, key = {} -> null serialized token", (Object)key);
        }
        session.put("pac4j_" + key, serialized);
    }

    public boolean destroySession(PlayWebContext playWebContext) {
        return false;
    }

    public Object getTrackableSession(PlayWebContext playWebContext) {
        return null;
    }

    public SessionStore<PlayWebContext> buildFromTrackableSession(PlayWebContext playWebContext, Object o) {
        return null;
    }

    public boolean renewSession(PlayWebContext playWebContext) {
        return false;
    }

    protected Object clearUserProfiles(Object value) {
        if (value instanceof LinkedHashMap) {
            LinkedHashMap profiles = (LinkedHashMap)value;
            profiles.forEach((name, profile) -> profile.clearSensitiveData());
            return profiles;
        }
        CommonProfile profile2 = (CommonProfile)value;
        profile2.clearSensitiveData();
        return profile2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] uncompressBytes(byte[] zippedBytes) {
        try (GZIPInputStream zipInputStream = new GZIPInputStream(new ByteArrayInputStream(zippedBytes));){
            byte[] byArray = IOUtils.toByteArray((InputStream)zipInputStream);
            return byArray;
        }
        catch (IOException e) {
            logger.error("Unable to uncompress session cookie", (Throwable)e);
            return null;
        }
    }

    public static byte[] compressBytes(byte[] srcBytes) {
        ByteArrayOutputStream resultBao = new ByteArrayOutputStream();
        try (GZIPOutputStream zipOutputStream = new GZIPOutputStream(resultBao);){
            zipOutputStream.write(srcBytes);
        }
        catch (IOException e) {
            logger.error("Unable to compress session cookie", (Throwable)e);
            return null;
        }
        return resultBao.toByteArray();
    }
}

