/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.profile;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.security.util.SpringSecurityHelper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class SpringSecurityProfileManager
extends ProfileManager {
    public SpringSecurityProfileManager(WebContext context, SessionStore sessionStore) {
        super(context, sessionStore);
    }

    protected void saveAll(LinkedHashMap<String, UserProfile> profiles, boolean saveInSession) {
        super.saveAll(profiles, saveInSession);
        Optional<Authentication> authentication = SpringSecurityHelper.computeAuthentication(profiles);
        if (authentication.isPresent()) {
            SecurityContextImpl securityContext = new SecurityContextImpl(authentication.get());
            SecurityContextHolder.setContext((SecurityContext)securityContext);
            if (saveInSession) {
                this.sessionStore.set(this.context, "SPRING_SECURITY_CONTEXT", (Object)securityContext);
            }
        }
    }

    public void removeProfiles() {
        super.removeProfiles();
        SecurityContextHolder.clearContext();
        this.sessionStore.set(this.context, "SPRING_SECURITY_CONTEXT", null);
    }
}

