/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.context.session.SessionStoreFactory;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.core.util.security.SecurityEndpoint;
import org.pac4j.core.util.security.SecurityEndpointBuilder;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.JEEContextFactory;
import org.pac4j.jee.context.session.JEESessionStoreFactory;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityInterceptor
implements HandlerInterceptor,
SecurityEndpoint {
    private SecurityLogic securityLogic;
    private String clients;
    private String authorizers;
    private String matchers;
    private Config config;
    private HttpActionAdapter httpActionAdapter;

    public SecurityInterceptor() {
    }

    public SecurityInterceptor(Config config) {
        this.config = config;
    }

    public SecurityInterceptor(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    @Deprecated
    public SecurityInterceptor(Config config, String clients, HttpActionAdapter httpActionAdapter) {
        this.clients = clients;
        this.config = config;
        this.httpActionAdapter = httpActionAdapter;
    }

    public SecurityInterceptor(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    @Deprecated
    public SecurityInterceptor(Config config, String clients, Authorizer[] authorizers) {
        this(config);
        SecurityEndpointBuilder.buildConfig((SecurityEndpoint)this, (Object[])new Object[]{config, clients, authorizers});
    }

    public SecurityInterceptor(Config config, String clients, String authorizers, String matchers) {
        this(config, clients, authorizers);
        this.matchers = matchers;
    }

    @Deprecated
    public SecurityInterceptor(Config config, String clients, Authorizer[] authorizers, Matcher[] matchers) {
        this(config);
        SecurityEndpointBuilder.buildConfig((SecurityEndpoint)this, (Object[])new Object[]{config, clients, authorizers, matchers});
    }

    public static SecurityInterceptor build(Object ... parameters) {
        SecurityInterceptor securityInterceptor = new SecurityInterceptor();
        SecurityEndpointBuilder.buildConfig((SecurityEndpoint)securityInterceptor, (Object[])parameters);
        return securityInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter((HttpActionAdapter)this.httpActionAdapter, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        SecurityLogic bestLogic = FindBest.securityLogic((SecurityLogic)this.securityLogic, (Config)this.config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        JEEContext context = (JEEContext)FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
        SessionStore sessionStore = FindBest.sessionStoreFactory(null, (Config)this.config, (SessionStoreFactory)JEESessionStoreFactory.INSTANCE).newSessionStore(new Object[]{request, response});
        Object result = bestLogic.perform((WebContext)context, sessionStore, this.config, (ctx, session, profiles, parameters) -> true, bestAdapter, this.clients, this.authorizers, this.matchers, new Object[0]);
        if (result == null) {
            return false;
        }
        return Boolean.parseBoolean(result.toString());
    }

    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public HttpActionAdapter getHttpActionAdapter() {
        return this.httpActionAdapter;
    }

    public void setHttpActionAdapter(HttpActionAdapter httpActionAdapter) {
        this.httpActionAdapter = httpActionAdapter;
    }
}

