/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.auth.Pac4jUser;
import org.pac4j.vertx.context.session.VertxSessionStore;

public class VertxProfileManager
extends ProfileManager {
    private final VertxWebContext vertxWebContext;

    public VertxProfileManager(VertxWebContext context, VertxSessionStore sessionStore) {
        super((WebContext)context, (SessionStore)sessionStore);
        this.vertxWebContext = context;
    }

    protected void saveAll(LinkedHashMap<String, UserProfile> profiles, boolean saveInSession) {
        super.saveAll(profiles, saveInSession);
        Pac4jUser vertxUser = Optional.ofNullable(this.vertxWebContext.getVertxUser()).orElse(new Pac4jUser());
        vertxUser.setUserProfiles(profiles);
        this.vertxWebContext.setVertxUser(vertxUser);
    }

    public void removeOrRenewExpiredProfiles(LinkedHashMap<String, UserProfile> profiles, boolean readFromSession) {
        super.removeOrRenewExpiredProfiles(profiles, readFromSession);
        this.vertxWebContext.removeVertxUser();
    }
}

